/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.certificates.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import org.dihedron.core.License;
import org.dihedron.crypto.certificates.CertificateLoader;
import org.dihedron.crypto.exceptions.CertificateLoaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class FileCertificateLoader
implements CertificateLoader {
    public static final String FILENAME = "filename";
    private static final Logger logger = LoggerFactory.getLogger(FileCertificateLoader.class);
    private CertificateFactory certificateFactory;

    public FileCertificateLoader() throws CertificateLoaderException {
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new CertificateLoaderException("error instantiating certificate factory", e);
        }
    }

    public byte[] loadCertificateData(String filename) throws CertificateLoaderException {
        Properties properties = new Properties();
        properties.put(FILENAME, filename);
        return this.loadCertificateData(properties);
    }

    public Certificate loadCertificate(String filename) throws CertificateLoaderException {
        Properties properties = new Properties();
        properties.put(FILENAME, filename);
        return this.loadCertificate(properties);
    }

    @Override
    public Certificate loadCertificate(Properties properties) throws CertificateLoaderException {
        Certificate certificate = null;
        try {
            byte[] data = this.loadCertificateData(properties);
            certificate = this.certificateFactory.generateCertificate(new ByteArrayInputStream(data));
        }
        catch (CertificateException e) {
            throw new CertificateLoaderException("error parsing certificate from file", e);
        }
        return certificate;
    }

    @Override
    public byte[] loadCertificateData(Properties properties) throws CertificateLoaderException {
        byte[] data;
        block17: {
            data = null;
            String filename = properties.getProperty(FILENAME);
            if (filename != null) {
                File f = new File(filename);
                try (FileInputStream fis = new FileInputStream(f);){
                    data = new byte[(int)f.length()];
                    if (((InputStream)fis).read(data) != (int)f.length()) {
                        logger.error("error reading data from file");
                        throw new CertificateLoaderException("error reading data from file");
                    }
                    break block17;
                }
                catch (FileNotFoundException e) {
                    logger.error("file '" + filename + "' not found", (Throwable)e);
                    throw new CertificateLoaderException("error loading file " + filename, e);
                }
                catch (IOException e) {
                    logger.error("error reading from file '" + filename + "'", (Throwable)e);
                    throw new CertificateLoaderException("error reading certificate from " + filename, e);
                }
            }
            logger.error("no valid filename supplied for certificate");
            throw new CertificateLoaderException("no valid filename supplied for certificate");
        }
        return data;
    }
}

