/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.constants;

import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.dihedron.core.License;

@License
public enum DigestAlgorithm {
    SHA1("sha-1", "SHA1", CMSSignedDataGenerator.DIGEST_SHA1),
    SHA224("sha-224", "SHA224", CMSSignedDataGenerator.DIGEST_SHA224),
    SHA256("sha-256", "SHA256", CMSSignedDataGenerator.DIGEST_SHA256),
    SHA384("sha-384", "SHA384", CMSSignedDataGenerator.DIGEST_SHA384),
    SHA512("sha-512", "SHA512", CMSSignedDataGenerator.DIGEST_SHA512),
    MD5("md5", "MD5", CMSSignedDataGenerator.DIGEST_MD5);

    private String description;
    private String bcCode;
    private String asn1Id;

    public static DigestAlgorithm fromDescription(String description) {
        for (DigestAlgorithm digest : DigestAlgorithm.values()) {
            if (!digest.getDescription().equalsIgnoreCase(description)) continue;
            return digest;
        }
        return null;
    }

    public static DigestAlgorithm fromAsn1Id(String asn1) {
        for (DigestAlgorithm digest : DigestAlgorithm.values()) {
            if (!digest.getAsn1Id().equalsIgnoreCase(asn1)) continue;
            return digest;
        }
        return null;
    }

    public static DigestAlgorithm fromBouncyCastleCode(String algorithmCode) {
        for (DigestAlgorithm digest : DigestAlgorithm.values()) {
            if (!digest.getBouncyCastleCode().equalsIgnoreCase(algorithmCode)) continue;
            return digest;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBouncyCastleCode() {
        return this.bcCode;
    }

    public String getAsn1Id() {
        return this.asn1Id;
    }

    public String toString() {
        return this.description + " ('" + this.bcCode + "', '" + this.asn1Id + "')";
    }

    private DigestAlgorithm(String description, String bcCode, String algorithmId) {
        this.description = description;
        this.bcCode = bcCode;
        this.asn1Id = algorithmId;
    }
}

