/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.constants;

import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.dihedron.core.License;

@License
public enum EncryptionAlgorithm {
    RSA("rsa", "RSA", CMSSignedDataGenerator.ENCRYPTION_RSA);

    private String description;
    private String bcCode;
    private String asn1Id;

    public static EncryptionAlgorithm fromDescription(String description) {
        for (EncryptionAlgorithm encryption : EncryptionAlgorithm.values()) {
            if (!encryption.getDescription().equalsIgnoreCase(description)) continue;
            return encryption;
        }
        return null;
    }

    public static EncryptionAlgorithm fromAsn1Id(String asn1) {
        for (EncryptionAlgorithm encryption : EncryptionAlgorithm.values()) {
            if (!encryption.getAsn1Id().equalsIgnoreCase(asn1)) continue;
            return encryption;
        }
        return null;
    }

    public static EncryptionAlgorithm fromBouncyCastleCode(String bcCode) {
        for (EncryptionAlgorithm encryption : EncryptionAlgorithm.values()) {
            if (!encryption.getBouncyCastleCode().equalsIgnoreCase(bcCode)) continue;
            return encryption;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBouncyCastleCode() {
        return this.bcCode;
    }

    public String getAsn1Id() {
        return this.asn1Id;
    }

    public String toString() {
        return this.description + " (" + this.asn1Id + ")";
    }

    private EncryptionAlgorithm(String description, String code, String asn1Id) {
        this.description = description;
        this.bcCode = code;
        this.asn1Id = asn1Id;
    }
}

