/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.operations.sign;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import org.dihedron.core.License;
import org.dihedron.crypto.CryptoService;
import org.dihedron.crypto.KeyRing;
import org.dihedron.crypto.exceptions.CryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public abstract class Signer
extends CryptoService {
    private static Logger logger = LoggerFactory.getLogger(Signer.class);
    protected String alias;
    protected KeyRing keyring = null;
    protected Provider provider = null;
    protected boolean encapsulate = true;

    protected Signer(String alias, KeyRing keyring, Provider provider) throws CryptoException {
        if (alias == null || keyring == null || provider == null) {
            throw new CryptoException("invalid initialisation data");
        }
        this.alias = alias;
        this.keyring = keyring;
        this.provider = provider;
    }

    public void setEncapsulateData(boolean encapsulate) {
        this.encapsulate = encapsulate;
    }

    public boolean isEncapsulateData() {
        logger.debug("data {} being encapsulated with the signature", (Object)(this.encapsulate ? "is" : "is not"));
        return this.encapsulate;
    }

    public abstract byte[] sign(byte[] var1) throws CryptoException;

    public abstract void sign(InputStream var1, OutputStream var2) throws CryptoException;
}

