/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.operations.sign.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import org.dihedron.core.License;
import org.dihedron.core.library.Traits;
import org.dihedron.core.streams.Streams;
import org.dihedron.crypto.Crypto;
import org.dihedron.crypto.KeyRing;
import org.dihedron.crypto.exceptions.CryptoException;
import org.dihedron.crypto.operations.sign.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class PDFSigner
extends Signer {
    private static Logger logger = LoggerFactory.getLogger(PDFSigner.class);
    private Key key = null;
    private Certificate[] chain = null;
    private Mode mode = null;

    public PDFSigner(String alias, KeyRing keyring, Provider provider) throws GeneralSecurityException, CryptoException {
        this(alias, keyring, provider, Mode.CONCURRENT);
    }

    public PDFSigner(String alias, KeyRing keyring, Provider provider, Mode mode) throws GeneralSecurityException, CryptoException {
        super(alias, keyring, provider);
        this.mode = mode;
        this.key = keyring.getPrivateKey(alias);
        this.chain = keyring.getCertificateChainAsArray(alias);
        logger.trace("PdfSigner initialised");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sign(byte[] data) throws CryptoException {
        byte[] byArray;
        ByteArrayInputStream input = null;
        ByteArrayOutputStream output = null;
        try {
            input = new ByteArrayInputStream(data);
            output = new ByteArrayOutputStream();
            this.sign(input, output);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            Streams.safelyClose(input);
            Streams.safelyClose(output);
            throw throwable;
        }
        Streams.safelyClose((InputStream)input);
        Streams.safelyClose((OutputStream)output);
        return byArray;
    }

    @Override
    public void sign(InputStream input, OutputStream output) throws CryptoException {
        try {
            PdfReader reader = new PdfReader(input);
            PdfStamper stamper = PdfStamper.createSignature((PdfReader)reader, (OutputStream)output, (char)'\u0000');
            PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
            appearance.setReason("Signed with Dihedron WebSign - Digital Signature for the Web ver. " + Crypto.valueOf(Traits.VERSION));
            appearance.setLocation("Hidden Signature");
            appearance.setCrypto((PrivateKey)this.key, this.chain, null, PdfSignatureAppearance.WINCER_SIGNED);
            if (this.mode == Mode.EXCLUSIVE) {
                appearance.setCertificationLevel(1);
            }
            stamper.close();
        }
        catch (IOException e) {
            logger.error("I/O exception writing the PDF", (Throwable)e);
            throw new CryptoException("I/O exception writing the PDF", e);
        }
        catch (DocumentException e) {
            logger.error("invalid document: exception writing the PDF", (Throwable)e);
            throw new CryptoException("document exception writing the PDF", e);
        }
    }

    @License
    public static enum Mode {
        EXCLUSIVE,
        CONCURRENT;

    }
}

