/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.operations.verify;

import org.dihedron.core.License;
import org.dihedron.crypto.exceptions.CryptoException;
import org.dihedron.crypto.exceptions.UnsupportedFormatException;
import org.dihedron.crypto.operations.EnvelopeFormat;
import org.dihedron.crypto.operations.verify.Verifier;
import org.dihedron.crypto.operations.verify.pkcs7.PKCS7Verifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class VerifierFactory {
    private static Logger logger = LoggerFactory.getLogger(VerifierFactory.class);

    public static Verifier makeVerifier(EnvelopeFormat format) throws CryptoException {
        PKCS7Verifier verifier = null;
        switch (format) {
            case PKCS7: {
                verifier = new PKCS7Verifier();
                break;
            }
            default: {
                logger.error("unsupported verifier type: '{}'", (Object)format);
                throw new UnsupportedFormatException("unsupported verifier type: " + (Object)((Object)format));
            }
        }
        return verifier;
    }
}

