/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.mscapi;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.dihedron.core.License;
import org.dihedron.crypto.KeyRing;
import org.dihedron.crypto.exceptions.CryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class MicrosoftKeyRing
extends KeyRing {
    private static final Logger logger = LoggerFactory.getLogger(MicrosoftKeyRing.class);
    public static final String MSCAPI_PERSONAL_KEYSTORE = "Windows-MY";

    public MicrosoftKeyRing(String password) throws CryptoException {
        try {
            if (this.keystore != null) {
                logger.info("reopening key store, need to cllose previous reference first");
                this.close();
            }
            logger.info("getting the keystore for MSCryptoAPI provider...");
            this.keystore = KeyStore.getInstance(MSCAPI_PERSONAL_KEYSTORE);
            logger.info("... keystore for MSCryptoAPI provider retrieved");
            this.keystore.load(null, password != null ? password.toCharArray() : null);
            logger.info("... keystore for MSCryptoAPI provider logged into");
        }
        catch (KeyStoreException e) {
            logger.error("error accessing the keystore", (Throwable)e);
            throw new CryptoException("Error accessing the keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("invalid algorithm specified in keystore access", (Throwable)e);
            throw new CryptoException("Invalid algorithm specified in keystore access", e);
        }
        catch (CertificateException e) {
            logger.error("error accessing the certificate", (Throwable)e);
            throw new CryptoException("Error accessing the certificate", e);
        }
        catch (IOException e) {
            logger.error("I/O exception while accessing the keystore", (Throwable)e);
            throw new CryptoException("I/O exception accessing the keystore", e);
        }
    }

    @Override
    public void close() {
    }
}

