/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.smartcard;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import org.dihedron.core.License;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class SmartCardCallbackHandler
implements CallbackHandler {
    private static final Logger logger = LoggerFactory.getLogger(SmartCardCallbackHandler.class);
    private String password;

    public SmartCardCallbackHandler(String password) {
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback callback = (PasswordCallback)callbacks[i];
                logger.trace("requesting smartcard password with message: '{}'", (Object)callback.getPrompt());
                callback.setPassword(this.password.toCharArray());
                continue;
            }
            logger.warn("unsupported callback type: '{}'", (Object)callbacks[i].getClass().getSimpleName());
        }
    }
}

