/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.smartcard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import org.dihedron.core.License;
import org.dihedron.crypto.providers.AutoCloseableProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class SmartCardProvider
extends AutoCloseableProvider {
    private static final long serialVersionUID = 4194148068514268505L;
    private static final Logger logger = LoggerFactory.getLogger(SmartCardProvider.class);

    public SmartCardProvider(Provider provider) {
        super(provider);
    }

    @Override
    public void close() {
        if (this.provider != null) {
            logger.info("closing provider '{}'...", (Object)this.getName());
            try {
                if (this.provider.getClass().getName().equals("sun.security.pkcs11.SunPKCS11")) {
                    logger.info("Sun PKCS#11 provider detected, trying to log out...");
                    Method logout = null;
                    for (Class<?> clazz = this.provider.getClass(); clazz != null && clazz != Object.class && logout == null; clazz = clazz.getSuperclass()) {
                        logout = clazz.getDeclaredMethod("logout", new Class[0]);
                    }
                    if (logout != null) {
                        logger.trace("... invoking logout() on provider");
                        logout.invoke((Object)this.provider, new Object[0]);
                        logger.info("... logged out of provider");
                    }
                }
            }
            catch (NoSuchMethodException e) {
                logger.error("no method logout() on Sun PKCS#11 provider", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("illegal access to method logout() on Sun PKCS#11 provider", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error("illegal arguments to method logout() on Sun PKCS#11 provider", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error("error trying to invoke logout() method on Sun PKCS#11 provider", (Throwable)e);
            }
        }
    }
}

