/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.smartcard;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import org.dihedron.core.License;
import org.dihedron.core.os.Platform;
import org.dihedron.crypto.exceptions.SmartCardException;
import org.dihedron.crypto.exceptions.UnavailableDriverException;
import org.dihedron.crypto.providers.AutoCloseableProvider;
import org.dihedron.crypto.providers.ProviderFactory;
import org.dihedron.crypto.providers.smartcard.SmartCardProvider;
import org.dihedron.crypto.providers.smartcard.SmartCardTraits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class SmartCardProviderFactory
extends ProviderFactory<SmartCardTraits> {
    private static final Logger logger = LoggerFactory.getLogger(SmartCardProviderFactory.class);

    @Override
    public AutoCloseableProvider getProvider(SmartCardTraits traits) throws UnavailableDriverException, SmartCardException {
        if (traits == null) {
            logger.warn("invalid smart card traits");
            return null;
        }
        String name = "SmartCard-" + traits.getSmartCard().getATR() + "-" + traits.getReader().getSlot();
        logger.info("installing PKCS#11 provider '(SunPKCS11-){}'...", (Object)name);
        InputStream stream = null;
        try {
            File driver = traits.getSmartCard().getDriver(Platform.getCurrent());
            if (driver != null) {
                logger.info("... file driver is available on disk at '{}'", (Object)driver.getAbsolutePath());
                Configuration configuration = new Configuration().setName(name).setLibrary(driver).setOnCardHashing(traits.isHashOnCard()).setSlot(traits.getReader().getSlot());
                logger.info("... provider configuration: \n{}", (Object)configuration);
                stream = configuration.toStream();
                Class<?> clazz = Class.forName("sun.security.pkcs11.SunPKCS11");
                Constructor<?> constructor = clazz.getConstructor(String.class, InputStream.class);
                Provider provider = (Provider)constructor.newInstance(name + "-configuration", stream);
                logger.info("... PKCS#11 provider '{}' loaded!", (Object)provider.getName());
                SmartCardProvider smartCardProvider = new SmartCardProvider(provider);
                return smartCardProvider;
            }
            try {
                logger.error("driver for smartcard '{}' and platform '{}' not available on disk", (Object)traits.getSmartCard().getATR(), (Object)Platform.getCurrent());
                throw new UnavailableDriverException("No valid smartcard PKCS#11 driver could be found on disk");
            }
            catch (ClassNotFoundException e) {
                logger.error("Sun PKCS#11 supporting classes not available", (Throwable)e);
                throw new SmartCardException("Sun PKCS#11 supporting classes not available", e);
            }
            catch (NoSuchMethodException e) {
                logger.error("no constructor with (String, InputStream) parameter for Sun PKCS#11 available", (Throwable)e);
                throw new SmartCardException("no constructor with (String, InputStream) parameter for Sun PKCS#11 available", e);
            }
            catch (SecurityException e) {
                logger.error("security exception accessing Sun PKCS#11 constructor", (Throwable)e);
                throw new SmartCardException("security exception accessing Sun PKCS#11 constructor", e);
            }
            catch (InstantiationException e) {
                logger.error("error invoking Sun PKCS#11 constructor", (Throwable)e);
                throw new SmartCardException("error invoking Sun PKCS#11 constructor", e);
            }
            catch (IllegalAccessException e) {
                logger.error("error invoking inaccessible Sun PKCS#11 constructor", (Throwable)e);
                throw new SmartCardException("error invoking inaccessible Sun PKCS#11 constructor", e);
            }
            catch (IllegalArgumentException e) {
                logger.error("illegal argument to Sun PKCS#11 constructor", (Throwable)e);
                throw new SmartCardException("illegal argument to Sun PKCS#11 constructor", e);
            }
            catch (InvocationTargetException e) {
                logger.error("generic error invoking Sun PKCS#11 constructor", (Throwable)e);
                throw new SmartCardException("generic error invoking Sun PKCS#11 constructor", e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.warn("error closing PKCS#11 provider configuration input stream", (Throwable)e);
                }
            }
        }
    }

    private static class Configuration {
        private StringBuilder buffer = new StringBuilder();

        Configuration() {
        }

        Configuration setName(String name) {
            this.buffer.append("name=").append(name).append("\n");
            return this;
        }

        Configuration setLibrary(File driver) {
            this.buffer.append("library=").append(driver.getAbsolutePath()).append("\n");
            return this;
        }

        Configuration setSlot(int slot) {
            this.buffer.append("slot=").append(slot).append("\n");
            return this;
        }

        Configuration setOnCardHashing(boolean enabled) {
            if (!enabled) {
                this.buffer.append("disabledMechanisms = {\n");
                this.buffer.append("    CKM_SHA1_RSA_PKCS\n");
                this.buffer.append("    CKM_SHA256_RSA_PKCS\n");
                this.buffer.append("    CKM_SHA384_RSA_PKCS\n");
                this.buffer.append("    CKM_SHA512_RSA_PKCS\n");
                this.buffer.append("}\n");
            }
            return this;
        }

        public String toString() {
            String configuration = this.buffer.toString();
            logger.trace("PKCS#11 configuration:\n{}", (Object)configuration);
            return configuration;
        }

        public InputStream toStream() {
            return new ByteArrayInputStream(this.buffer.toString().getBytes());
        }
    }
}

