/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.smartcard.discovery;

import org.dihedron.core.License;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class ATR {
    private static final Logger logger = LoggerFactory.getLogger(ATR.class);
    private String atr;

    public ATR(String atr) {
        this.atr = atr.toUpperCase();
    }

    public ATR(byte[] bytes) {
        this(bytes, "");
    }

    public ATR(byte[] bytes, String separator) {
        StringBuilder buffer = new StringBuilder();
        for (int n = 0; n < bytes.length; ++n) {
            int x = 0xFF & bytes[n];
            String w = Integer.toHexString(x).toUpperCase();
            if (w.length() == 1) {
                w = "0" + w;
            }
            buffer.append(w).append(n + 1 == bytes.length ? "" : separator);
        }
        this.atr = buffer.toString().toUpperCase();
    }

    public boolean equals(Object other) {
        logger.trace("checking equality between '{}' (this) and '{}' (other)...", (Object)this.atr, (Object)((ATR)other).atr);
        boolean result = other != null && other instanceof ATR && ((ATR)other).atr.equals(this.atr);
        logger.trace("... objects {} equal", (Object)(result ? "are" : "are not"));
        return result;
    }

    public int hashCode() {
        return this.atr.hashCode();
    }

    public String toString() {
        return this.atr;
    }
}

