/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.smartcard.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.dihedron.core.License;
import org.dihedron.core.url.URLFactory;
import org.dihedron.crypto.exceptions.SmartCardException;
import org.dihedron.crypto.providers.smartcard.discovery.DataBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@License
public final class DataBaseLoader {
    private static final Logger logger = LoggerFactory.getLogger(DataBaseLoader.class);
    private static final boolean VALIDATE_XML = false;
    public static final String SMARTCARDS_XSD = "classpath:org/dihedron/crypto/providers/smartcard/discovery/smartcards.xsd";
    public static final String DEFAULT_SMARTCARDS_XML = "classpath:org/dihedron/crypto/providers/smartcard/discovery/smartcards.xml";

    public static DataBase load() throws SmartCardException {
        return DataBaseLoader.load(DEFAULT_SMARTCARDS_XML);
    }

    public static DataBase load(String specification) throws SmartCardException {
        String address = specification != null ? specification : DEFAULT_SMARTCARDS_XML;
        try {
            URL url = URLFactory.makeURL((String)address);
            return DataBaseLoader.load(url);
        }
        catch (MalformedURLException e) {
            logger.error("the URL specification '{}' is not valid", (Object)address);
            throw new SmartCardException("invalid input URL specification '" + address + "'", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DataBase load(URL url) throws SmartCardException {
        URL address = null;
        try {
            address = url != null ? url : URLFactory.makeURL((String)DEFAULT_SMARTCARDS_XML);
        }
        catch (MalformedURLException e) {
            logger.error("input URL is invalid and default URL for database is malformed", (Throwable)e);
            throw new SmartCardException("Invalid input URL and malformed default URL for database", e);
        }
        try (InputStream stream = address.openStream();){
            DataBase dataBase = DataBaseLoader.load(stream);
            return dataBase;
        }
        catch (IOException e) {
            logger.error("error loading from URL '{}'", (Object)url);
            throw new SmartCardException("Error reading database XML from stream", e);
        }
    }

    /*
     * Exception decompiling
     */
    public static DataBase load(InputStream input) throws SmartCardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class ConfigurationErrorHandler
    implements ErrorHandler {
        private ConfigurationErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            logger.warn(e.getMessage(), (Throwable)e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            logger.error(e.getMessage(), (Throwable)e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

