/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.smartcard.discovery;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dihedron.core.License;
import org.dihedron.core.os.HardDrives;
import org.dihedron.core.os.Platform;
import org.dihedron.core.variables.EnvironmentValueProvider;
import org.dihedron.core.variables.SystemPropertyValueProvider;
import org.dihedron.core.variables.ValueProvider;
import org.dihedron.core.variables.Variables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class Driver {
    private static final Logger logger = LoggerFactory.getLogger(Driver.class);
    private static final String ALL_DRIVES = "@{ALL_DRIVES}";
    private Platform platform;
    private List<String> paths;

    Driver(String platform) {
        this(Platform.fromString((String)platform));
    }

    Driver(Platform platform) {
        logger.trace("instantiating driver for platform '{}'", (Object)platform);
        this.platform = platform;
        this.paths = new ArrayList<String>();
    }

    public Platform getPlatform() {
        return this.platform;
    }

    void addPath(String path) {
        if (path != null && path.trim().length() > 0) {
            logger.trace("supporting library: '{}'", (Object)path);
            this.paths.add(path);
        }
    }

    File find() {
        ArrayList<String> pathsToTest = new ArrayList<String>();
        for (String path : this.paths) {
            logger.trace("analysing path '{}'", (Object)path);
            if (path.startsWith(ALL_DRIVES)) {
                List roots = HardDrives.listAll((String[])new String[0]);
                String temp = path.replace(ALL_DRIVES, "");
                for (File root : roots) {
                    String newPath = root.getAbsolutePath() + temp;
                    logger.trace("adding new generated path '{}'", (Object)newPath);
                    pathsToTest.add(newPath);
                }
                continue;
            }
            pathsToTest.add(path);
        }
        for (String path : pathsToTest) {
            path = Variables.replaceVariables((String)path, (ValueProvider[])new ValueProvider[]{new SystemPropertyValueProvider(), new EnvironmentValueProvider()});
            logger.trace("trying to locate driver library '{}'...", (Object)path);
            File file = new File(path);
            if (!file.exists() || !file.isFile()) continue;
            logger.info("library '{}' found", (Object)path);
            return file;
        }
        logger.info("no supporting library found");
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("driver: { platform: '").append(this.platform).append("', paths: [");
        boolean first = true;
        for (String path : this.paths) {
            buffer.append(first ? "'" : ", '").append(path).append("'");
            first = false;
        }
        buffer.append("] },");
        return buffer.toString();
    }
}

