/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.ui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.dihedron.core.License;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class PINDialog
extends JDialog
implements ActionListener {
    public static final boolean DEFAULT_MODALITY = true;
    private static final long serialVersionUID = -4012173637510636595L;
    private static final Logger logger = LoggerFactory.getLogger(PINDialog.class);
    private char[] pin = null;
    private JLabel caption;
    private JLabel label;
    private JButton ok;
    private JButton cancel;
    private JPasswordField password;

    public PINDialog() {
        this(null, true, null, null);
    }

    public PINDialog(Frame parent) {
        this(parent, true, null, null);
    }

    public PINDialog(boolean modal) {
        this((Frame)null, modal);
    }

    public PINDialog(Frame parent, boolean modal) {
        this(parent, modal, null, null);
    }

    public PINDialog(String title, String caption) {
        this(null, true, title, caption);
    }

    public PINDialog(Frame parent, boolean modal, String title) {
        this(parent, modal, title, null);
    }

    public PINDialog(Frame parent, boolean modal, String title, String caption) {
        super(parent, title, modal);
        this.setLocationRelativeTo(parent);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            logger.error("error installing system look'n'feel", (Throwable)e);
        }
        this.initComponents(caption);
    }

    public PINDialog setDialogTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public String getPIN() {
        this.setVisible(true);
        if (this.pin != null) {
            return new String(this.pin);
        }
        return null;
    }

    private void initComponents(String caption) {
        this.caption = caption == null ? new JLabel("Insert PIN for smartcard") : new JLabel(caption);
        this.label = new JLabel();
        this.password = new JPasswordField();
        this.ok = new JButton();
        this.cancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.label.setText("PIN:");
        this.ok.setText("OK");
        this.getRootPane().setDefaultButton(this.ok);
        this.ok.addActionListener(this);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(this);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.caption, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.label).addGap(18, 18, 18).addComponent(this.password)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 221, Short.MAX_VALUE).addComponent(this.ok, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancel, -2, 76, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.caption, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.password, -2, -1, -2).addComponent(this.label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.ok).addComponent(this.cancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "OK": {
                logger.trace("OK pressed");
                this.pin = this.password.getPassword();
                this.dispose();
                break;
            }
            case "Cancel": {
                logger.trace("Cancel pressed");
                this.pin = null;
                this.dispose();
            }
        }
    }
}

