/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.certificates;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.dihedron.core.License;
import org.dihedron.crypto.certificates.CertificateLoader;
import org.dihedron.crypto.certificates.impl.FileCertificateLoader;
import org.dihedron.crypto.certificates.impl.LDAPCertificateLoader;
import org.dihedron.crypto.exceptions.CertificateLoaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class CertificateLoaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(CertificateLoaderFactory.class);
    private static final String DEFAULT_PROPERTIES_FILENAME = "certificate_loader.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertificateLoader makeCertificateLoader(String filename) throws FileNotFoundException, IOException, CertificateLoaderException {
        String file = filename;
        if (file == null) {
            file = DEFAULT_PROPERTIES_FILENAME;
        }
        FileInputStream stream = null;
        try {
            Properties properties = new Properties();
            stream = new FileInputStream(file);
            properties.load(stream);
            CertificateLoader certificateLoader = CertificateLoaderFactory.makeCertificateLoader(properties);
            return certificateLoader;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.error("error closing properties file stream");
                }
            }
        }
    }

    public static CertificateLoader makeCertificateLoader(Properties properties) throws CertificateLoaderException {
        assert (properties != null);
        String provider = (String)properties.get("provider");
        if (provider.equalsIgnoreCase("file")) {
            logger.info("instantiating a FileCertificateLoader...");
            return new FileCertificateLoader();
        }
        if (provider.equalsIgnoreCase("ldap")) {
            logger.info("instantiating a LDAPCertificateLoader...");
            if (properties.containsKey("ldap.url")) {
                String ldapUrl = (String)properties.get("ldap.url");
                return new LDAPCertificateLoader(ldapUrl);
            }
            String ldapServer = (String)properties.get("ldap.server");
            String ldapPort = (String)properties.get("ldap.port");
            return new LDAPCertificateLoader(ldapServer, Integer.parseInt(ldapPort));
        }
        return null;
    }

    private CertificateLoaderFactory() {
    }
}

