/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.certificates.impl;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.dihedron.core.License;
import org.dihedron.crypto.certificates.CertificateLoader;
import org.dihedron.crypto.certificates.Certificates;
import org.dihedron.crypto.exceptions.CertificateLoaderException;

@License
public class LDAPCertificateLoader
implements CertificateLoader {
    private CertificateFactory certificateFactory;
    private DirContext ldapContext;
    private SearchControls controls;

    public LDAPCertificateLoader(String ldapServer, int port) throws CertificateLoaderException {
        String providerUrl = new String("ldap://" + ldapServer + ":" + port + "/");
        this.initialise(providerUrl);
    }

    public LDAPCertificateLoader(String ldapProviderUrl) throws CertificateLoaderException {
        this.initialise(ldapProviderUrl);
    }

    private void initialise(String ldapProviderUrl) throws CertificateLoaderException {
        try {
            Hashtable<String, String> environment = new Hashtable<String, String>();
            environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            environment.put("java.naming.provider.url", ldapProviderUrl);
            this.ldapContext = new InitialDirContext(environment);
            this.controls = new SearchControls();
            this.controls.setSearchScope(2);
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new CertificateLoaderException("error instantiating certificate factory", e);
        }
        catch (NamingException e) {
            throw new CertificateLoaderException("error establishing directory context", e);
        }
    }

    public byte[] loadCertificateData(String name, String filter) throws CertificateLoaderException {
        Properties properties = new Properties();
        properties.setProperty("name", name);
        properties.setProperty("filter", filter);
        return this.loadCertificateData(properties);
    }

    @Override
    public byte[] loadCertificateData(Properties properties) throws CertificateLoaderException {
        byte[] data = null;
        String name = properties.getProperty("name");
        String filter = properties.getProperty("filter");
        boolean found = false;
        try {
            NamingEnumeration<SearchResult> results = this.ldapContext.search(name, filter, this.controls);
            block3: while (results.hasMore() && !found) {
                SearchResult searchResult = results.next();
                Attributes attributes = searchResult.getAttributes();
                Attribute attribute = attributes.get("userCertificate;binary");
                if (attribute == null) continue;
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMoreElements()) {
                    data = (byte[])values.nextElement();
                    X509Certificate x509certificate = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(data));
                    if (Certificates.isSignatureX509Certificate(x509certificate)) {
                        found = true;
                        continue block3;
                    }
                    x509certificate = null;
                }
            }
        }
        catch (NamingException e) {
            throw new CertificateLoaderException("ldap search error", e);
        }
        catch (CertificateException e) {
            throw new CertificateLoaderException("error parsing certificate", e);
        }
        return data;
    }

    public Certificate loadCertificate(String name, String filter) throws CertificateLoaderException {
        Properties properties = new Properties();
        properties.setProperty("name", name);
        properties.setProperty("filter", filter);
        return this.loadCertificate(properties);
    }

    @Override
    public Certificate loadCertificate(Properties props) throws CertificateLoaderException {
        X509Certificate x509certificate = null;
        byte[] data = this.loadCertificateData(props);
        if (data != null) {
            try {
                x509certificate = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(data));
            }
            catch (CertificateException e) {
                throw new CertificateLoaderException("error parsing certificate", e);
            }
        }
        return x509certificate;
    }
}

