/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.constants;

import java.util.List;
import org.dihedron.core.License;
import org.dihedron.core.regex.Regex;
import org.dihedron.crypto.constants.DigestAlgorithm;
import org.dihedron.crypto.constants.EncryptionAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public enum SignatureAlgorithm {
    MD5_WITH_RSA(DigestAlgorithm.MD5, EncryptionAlgorithm.RSA),
    SHA1_WITH_RSA(DigestAlgorithm.SHA1, EncryptionAlgorithm.RSA),
    SHA224_WITH_RSA(DigestAlgorithm.SHA224, EncryptionAlgorithm.RSA),
    SHA256_WITH_RSA(DigestAlgorithm.SHA256, EncryptionAlgorithm.RSA),
    SHA384_WITH_RSA(DigestAlgorithm.SHA384, EncryptionAlgorithm.RSA),
    SHA512_WITH_RSA(DigestAlgorithm.SHA512, EncryptionAlgorithm.RSA);

    private Logger logger = LoggerFactory.getLogger(SignatureAlgorithm.class);
    private DigestAlgorithm digestAlgorithm;
    private EncryptionAlgorithm encryptionAlgorithm;

    public static SignatureAlgorithm fromBouncyCastleCode(String bcCode) {
        Regex regex = new Regex("(.*)with(.*)");
        if (regex.matches(bcCode)) {
            List matches = regex.getAllMatches(bcCode);
            return SignatureAlgorithm.fromBouncyCastleCodes(((String[])matches.get(0))[0], ((String[])matches.get(0))[1]);
        }
        return null;
    }

    public static SignatureAlgorithm fromAlgorithmDescriptions(String digestAlgorithm, String encryptionAlgorithm) {
        DigestAlgorithm digest = DigestAlgorithm.fromDescription(digestAlgorithm);
        EncryptionAlgorithm encryption = EncryptionAlgorithm.fromDescription(encryptionAlgorithm);
        for (SignatureAlgorithm signature : SignatureAlgorithm.values()) {
            if (digest != signature.digestAlgorithm || encryption != signature.encryptionAlgorithm) continue;
            return signature;
        }
        return null;
    }

    public static SignatureAlgorithm fromAlgorithmAsn1Ids(String digestAlgorithm, String encryptionAlgorithm) {
        DigestAlgorithm digest = DigestAlgorithm.fromAsn1Id(digestAlgorithm);
        EncryptionAlgorithm encryption = EncryptionAlgorithm.fromAsn1Id(encryptionAlgorithm);
        for (SignatureAlgorithm signature : SignatureAlgorithm.values()) {
            if (digest != signature.digestAlgorithm || encryption != signature.encryptionAlgorithm) continue;
            return signature;
        }
        return null;
    }

    public static SignatureAlgorithm fromBouncyCastleCodes(String digestAlgorithm, String encryptionAlgorithm) {
        DigestAlgorithm digest = DigestAlgorithm.fromBouncyCastleCode(digestAlgorithm);
        EncryptionAlgorithm encryption = EncryptionAlgorithm.fromBouncyCastleCode(encryptionAlgorithm);
        for (SignatureAlgorithm signature : SignatureAlgorithm.values()) {
            if (digest != signature.digestAlgorithm || encryption != signature.encryptionAlgorithm) continue;
            return signature;
        }
        return null;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String toBouncyCastleCode() {
        StringBuffer algorithm = new StringBuffer();
        algorithm.append(this.digestAlgorithm.getBouncyCastleCode()).append("with").append(this.encryptionAlgorithm.getBouncyCastleCode());
        this.logger.debug("signature algorithm: '{}'", (Object)algorithm.toString());
        return algorithm.toString();
    }

    public String toString() {
        return this.toBouncyCastleCode();
    }

    private SignatureAlgorithm(DigestAlgorithm digestAlgorithm, EncryptionAlgorithm encryptionAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.logger.debug("digest algorithm: '{}', encryption algorithm: '{}'", (Object)digestAlgorithm, (Object)encryptionAlgorithm);
    }
}

