/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.crl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.dihedron.core.License;
import org.dihedron.crypto.exceptions.CertificateVerificationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License(copyright="Copyright (c) 2012-2014 Andrea Funto', Svetlin Nakov")
public class CRL {
    private static final Logger logger = LoggerFactory.getLogger(CRL.class);

    public static X509CRL fromURL(String url) throws IOException, CertificateException, CRLException, CertificateVerificationException, NamingException {
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://")) {
            return CRL.fromWeb(url);
        }
        if (url.startsWith("ldap://")) {
            return CRL.fromLDAP(url);
        }
        throw new CertificateVerificationException("Cannot download CRL from certificate distribution point: '" + url + "'");
    }

    public static X509CRL fromLDAP(String ldapURL) throws CertificateException, NamingException, CRLException, CertificateVerificationException, IOException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes attributes = ctx.getAttributes("");
        Attribute attribute = attributes.get("certificateRevocationList;binary");
        byte[] value = (byte[])attribute.get();
        if (value == null || value.length == 0) {
            throw new CertificateVerificationException("error downloading CRL from '" + ldapURL + "'");
        }
        try (ByteArrayInputStream inStream = new ByteArrayInputStream(value);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL x509CRL = (X509CRL)cf.generateCRL(inStream);
            return x509CRL;
        }
    }

    public static X509CRL fromWeb(String crlURL) throws MalformedURLException, IOException, CertificateException, CRLException {
        URL url = new URL(crlURL);
        try (InputStream stream = url.openStream();){
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509CRL x509CRL = (X509CRL)factory.generateCRL(stream);
            return x509CRL;
        }
    }

    public static void verifyCertificateCRLs(X509Certificate certificate) throws CertificateVerificationException {
        try {
            logger.trace("verifying certificate {}...", (Object)certificate.getSubjectX500Principal());
            List<String> distributionPoints = CRL.getCrlDistributionPoints(certificate);
            for (String distributionPoint : distributionPoints) {
                try {
                    logger.trace("... checking distribution point '{}'...", (Object)distributionPoint);
                    X509CRL crl = CRL.fromURL(distributionPoint);
                    logger.trace("... CRL downloaded...", (Object)distributionPoint);
                    if (crl.isRevoked(certificate)) {
                        logger.info("certificate is revoked by CRL at '{}'", (Object)distributionPoint);
                        throw new CertificateVerificationException("The certificate is revoked by CRL: " + distributionPoint);
                    }
                    logger.trace("... certificate is not revoked by CRL at '{}'", (Object)distributionPoint);
                }
                catch (IOException | CRLException | CertificateException | NamingException e) {
                    logger.warn("... error verifying against distribution point '{}'", (Object)distributionPoint);
                }
            }
        }
        catch (IOException | CertificateParsingException e) {
            logger.error("error parsing certificate to get distribution points", (Throwable)e);
            throw new CertificateVerificationException("Cannot verify CRL for certificate: " + certificate.getSubjectX500Principal(), e);
        }
    }

    /*
     * Exception decompiling
     */
    public static List<String> getCrlDistributionPoints(X509Certificate certificate) throws CertificateParsingException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

