/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.operations.sign;

import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import org.dihedron.core.License;
import org.dihedron.crypto.KeyRing;
import org.dihedron.crypto.constants.SignatureAlgorithm;
import org.dihedron.crypto.exceptions.CryptoException;
import org.dihedron.crypto.exceptions.UnsupportedFormatException;
import org.dihedron.crypto.operations.EnvelopeFormat;
import org.dihedron.crypto.operations.sign.Signer;
import org.dihedron.crypto.operations.sign.pkcs7.PKCS7Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class SignerFactory {
    private static Logger logger = LoggerFactory.getLogger(SignerFactory.class);

    public static Signer makeSigner(EnvelopeFormat format, String alias, KeyRing keyring, Provider provider, SignatureAlgorithm algorithm) throws CryptoException, CertificateEncodingException, CertificateNotYetValidException, KeyStoreException, CertificateExpiredException {
        PKCS7Signer signer = null;
        switch (format) {
            case PKCS7: {
                signer = new PKCS7Signer(alias, keyring, provider, algorithm);
                break;
            }
            default: {
                logger.error("unsupported signer type: '{}'", (Object)format);
                throw new UnsupportedFormatException("unsupported signer type: " + (Object)((Object)format));
            }
        }
        return signer;
    }
}

