/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.operations.sign;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dihedron.core.License;
import org.dihedron.crypto.KeyRing;
import org.dihedron.crypto.certificates.Certificates;
import org.dihedron.crypto.constants.SignatureAlgorithm;
import org.dihedron.crypto.exceptions.CryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class SigningStreamConfigurator {
    public static final boolean DEFAULT_ENCAPSULATE_DATA = true;
    public static final boolean DEFAULT_VERIFY_CERTIFICATE = true;
    private static final Logger logger = LoggerFactory.getLogger(SigningStreamConfigurator.class);
    protected SignatureAlgorithm algorithm;
    protected String alias;
    protected KeyRing keyring = null;
    protected Provider provider = null;
    protected List<X509Certificate> trustAnchors = new ArrayList<X509Certificate>();
    protected boolean encapsulateData = true;
    protected boolean verifyCertificate = true;

    public SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public SigningStreamConfigurator setAlgorithm(SignatureAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public SigningStreamConfigurator setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public KeyRing getKeyRing() {
        return this.keyring;
    }

    public SigningStreamConfigurator setKeyRing(KeyRing keyring) {
        this.keyring = keyring;
        return this;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public SigningStreamConfigurator setProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public boolean isEncapsulateData() {
        logger.trace("encapsulate data: {}", (Object)this.encapsulateData);
        return this.encapsulateData;
    }

    public SigningStreamConfigurator setEncapsulateData(boolean encapsulateData) {
        this.encapsulateData = encapsulateData;
        return this;
    }

    public boolean isVerifyCertificate() {
        return this.verifyCertificate;
    }

    public SigningStreamConfigurator setVerifyCertificate(boolean verifyCertificate) {
        this.verifyCertificate = verifyCertificate;
        return this;
    }

    public Collection<X509Certificate> getTrustAnchors() {
        return this.trustAnchors;
    }

    public SigningStreamConfigurator addTrustAnchor(Certificate trustAnchor) {
        if (trustAnchor != null && trustAnchor instanceof X509Certificate) {
            this.trustAnchors.add((X509Certificate)trustAnchor);
        }
        return this;
    }

    public SigningStreamConfigurator addTrustAnchors(Collection<X509Certificate> trustAnchors) {
        if (trustAnchors != null) {
            this.trustAnchors.addAll(trustAnchors);
        }
        return this;
    }

    public SigningStreamConfigurator clearTrustAnchors() {
        this.trustAnchors.clear();
        return this;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        buffer.append("\talias            : '").append(this.alias).append("',\n");
        buffer.append("\tprovider         : '").append(this.provider.getName()).append("',\n");
        buffer.append("\talgorithm        : '").append(this.algorithm.toString()).append("',\n");
        buffer.append("\tencapsulate data : '").append(this.encapsulateData).append("',\n");
        buffer.append("\tverify certif.   : '").append(this.verifyCertificate).append("',\n");
        buffer.append("\ttrust anchors    : '").append(this.trustAnchors.isEmpty() ? "empty" : this.trustAnchors.size() + " elements").append("'\n");
        buffer.append("}");
        return buffer.toString();
    }

    public Key getPrivateKey() throws CryptoException {
        return this.keyring.getPrivateKey(this.alias);
    }

    public X509Certificate getCertificate() throws CryptoException, KeyStoreException, GeneralSecurityException, CertificateExpiredException, CertificateNotYetValidException {
        X509Certificate certificate = null;
        try {
            certificate = (X509Certificate)this.keyring.getCertificate(this.alias);
            certificate.checkValidity();
            logger.info("certificate is valid at current date");
            if (this.verifyCertificate) {
                logger.info("performing extensive certificate verification through TLS and CRLs...");
                ArrayList<X509Certificate> anchors = new ArrayList<X509Certificate>();
                if (this.trustAnchors != null) {
                    anchors.addAll(this.trustAnchors);
                }
                for (Certificate c : this.keyring.getCertificateChain(this.alias)) {
                    if (c == null || !(c instanceof X509Certificate)) continue;
                    anchors.add((X509Certificate)c);
                }
                PKIXCertPathBuilderResult verified = Certificates.verifyCertificate(certificate, anchors);
                logger.info("... certificate has valid certification path and is not revoked (CRL check ok)");
                logger.trace("... certification path: ");
                for (Certificate certificate2 : verified.getCertPath().getCertificates()) {
                    logger.trace("...  - step in certification path:\n{}", (Object)certificate2);
                }
                logger.trace("... trust anchor: '{}'\n{}", (Object)verified.getTrustAnchor().getCAName(), (Object)verified.getTrustAnchor().getTrustedCert());
                logger.trace("... public key:\n{}", (Object)verified.getPublicKey());
                logger.info("... verification complete");
            }
            return certificate;
        }
        catch (CertificateExpiredException e) {
            logger.error("certificate expired at the current date (valid from " + certificate.getNotBefore() + " to " + certificate.getNotAfter() + ")", (Throwable)e);
            throw e;
        }
        catch (CertificateNotYetValidException e) {
            logger.error("certificate not yet valid at the current date (valid from " + certificate.getNotBefore() + " to " + certificate.getNotAfter() + ")", (Throwable)e);
            throw e;
        }
    }
}

