/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.operations.sign.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.dihedron.core.License;
import org.dihedron.core.streams.Streams;
import org.dihedron.crypto.KeyRing;
import org.dihedron.crypto.constants.SignatureAlgorithm;
import org.dihedron.crypto.exceptions.CryptoException;
import org.dihedron.crypto.operations.sign.Signer;
import org.dihedron.crypto.operations.sign.pkcs7.PKCS7AttributeTableGenerator;
import org.dihedron.crypto.providers.AutoCloseableProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class PKCS7Signer
extends Signer {
    private static Logger logger = LoggerFactory.getLogger(PKCS7Signer.class);
    private CMSSignedDataStreamGenerator generator = null;

    public PKCS7Signer(String alias, KeyRing keyring, Provider provider, SignatureAlgorithm algorithm) throws CryptoException, KeyStoreException, CertificateEncodingException, CertificateNotYetValidException, CertificateExpiredException {
        super(alias, keyring, provider);
        logger.debug("creating PKCS#7 signer with '{}' signature algorithm", (Object)algorithm);
        try {
            logger.info("signing with alias '{}'", (Object)alias);
            Key key = keyring.getPrivateKey(alias);
            X509Certificate x509certificate = (X509Certificate)keyring.getCertificate(alias);
            x509certificate.checkValidity();
            logger.info("certificate is valid at current date");
            logger.info("certificate is active at current date (CRL check successful)");
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            certificates.add(x509certificate);
            JcaCertStore store = new JcaCertStore(certificates);
            logger.info("certificate store is ready");
            ContentSigner signer = new JcaContentSignerBuilder(algorithm.toBouncyCastleCode()).setProvider(provider instanceof AutoCloseableProvider ? ((AutoCloseableProvider)provider).getWrappedProvider() : provider).build((PrivateKey)key);
            DigestCalculatorProvider digest = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
            SignerInfoGenerator signerinfo = new SignerInfoGeneratorBuilder(digest).setDirectSignature(false).setSignedAttributeGenerator((CMSAttributeTableGenerator)new PKCS7AttributeTableGenerator(algorithm.getDigestAlgorithm(), x509certificate)).build(signer, (X509CertificateHolder)new JcaX509CertificateHolder(x509certificate));
            logger.info("signer info generator is ready");
            this.generator = new CMSSignedDataStreamGenerator();
            this.generator.addSignerInfoGenerator(signerinfo);
            this.generator.addCertificates((Store)store);
            logger.debug("signed data stream generator for PKCS#7 is ready");
        }
        catch (OperatorCreationException e) {
            logger.error("error creating operator", (Throwable)e);
            throw new CryptoException("error creating signing operator (BouncyCastle)", e);
        }
        catch (CertificateEncodingException e) {
            logger.error("invalid certificate encoding", (Throwable)e);
            throw e;
        }
        catch (CertificateExpiredException e) {
            logger.error("expired certificate", (Throwable)e);
            throw e;
        }
        catch (CertificateNotYetValidException e) {
            logger.error("certificate is not yet valid (may still need to be activated?)", (Throwable)e);
            throw e;
        }
        catch (CMSException e) {
            logger.error("error adding certificates to signature generator", (Throwable)e);
            throw new CryptoException("CMS error", e);
        }
    }

    public PKCS7Signer(String alias, KeyRing keyring, Provider provider, String digest, String encryption) throws CryptoException, CertificateEncodingException, CertificateNotYetValidException, KeyStoreException, CertificateExpiredException {
        this(alias, keyring, provider, SignatureAlgorithm.fromAlgorithmDescriptions(digest, encryption));
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] sign(byte[] data) throws CryptoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void sign(InputStream input, OutputStream output) throws CryptoException {
        try (OutputStream stream = this.generator.open(output, this.encapsulate);){
            logger.trace("copying data into generator filter stream...");
            long copied = Streams.copy((InputStream)input, (OutputStream)stream);
            logger.trace("... done copying {} bytes into generator filter stream", (Object)copied);
        }
        catch (IOException e) {
            logger.error("error opening signature generator wrapper output stream", (Throwable)e);
            throw new CryptoException("error opening signature generator wrapper output stream", e);
        }
    }
}

