/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.operations.sign.pkcs7;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.dihedron.core.License;
import org.dihedron.crypto.constants.SignatureAlgorithm;
import org.dihedron.crypto.exceptions.CryptoException;
import org.dihedron.crypto.operations.sign.SigningStream;
import org.dihedron.crypto.operations.sign.SigningStreamConfigurator;
import org.dihedron.crypto.operations.sign.pkcs7.PKCS7AttributeTableGenerator;
import org.dihedron.crypto.providers.AutoCloseableProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class PKCS7SigningStream
extends SigningStream {
    private static final Logger logger = LoggerFactory.getLogger(PKCS7SigningStream.class);
    private CMSSignedDataStreamGenerator generator = null;
    private OutputStream stream = null;

    public PKCS7SigningStream(OutputStream output, SigningStreamConfigurator configurator) throws CryptoException, CertificateExpiredException, CertificateNotYetValidException, CertificateEncodingException, GeneralSecurityException {
        super(output, configurator);
        logger.info("creating PKCS#7 signing filter output stream with '{}' signature algorithm, using certificate alias '{}'", (Object)configurator.getAlgorithm(), (Object)configurator.getAlias());
        try {
            logger.info("signing with alias '{}'", (Object)configurator.getAlias());
            Key key = configurator.getPrivateKey();
            X509Certificate x509certificate = configurator.getCertificate();
            Provider provider = configurator.getProvider();
            SignatureAlgorithm algorithm = configurator.getAlgorithm();
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            certificates.add(x509certificate);
            JcaCertStore store = new JcaCertStore(certificates);
            logger.info("certificate store is ready");
            ContentSigner signer = new JcaContentSignerBuilder(algorithm.toBouncyCastleCode()).setProvider(provider instanceof AutoCloseableProvider ? ((AutoCloseableProvider)provider).getWrappedProvider() : provider).build((PrivateKey)key);
            DigestCalculatorProvider digest = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
            SignerInfoGenerator signerinfo = new SignerInfoGeneratorBuilder(digest).setDirectSignature(false).setSignedAttributeGenerator((CMSAttributeTableGenerator)new PKCS7AttributeTableGenerator(algorithm.getDigestAlgorithm(), x509certificate)).build(signer, (X509CertificateHolder)new JcaX509CertificateHolder(x509certificate));
            logger.info("signer info generator is ready");
            this.generator = new CMSSignedDataStreamGenerator();
            this.generator.addSignerInfoGenerator(signerinfo);
            this.generator.addCertificates((Store)store);
            logger.debug("signed data stream generator for PKCS#7 is ready");
            this.stream = this.generator.open(output, configurator.isEncapsulateData());
        }
        catch (OperatorCreationException e) {
            logger.error("error creating operator", (Throwable)e);
            throw new CryptoException("error creating signing operator (BouncyCastle)", e);
        }
        catch (CertificateEncodingException e) {
            logger.error("invalid certificate encoding", (Throwable)e);
            throw e;
        }
        catch (CMSException e) {
            logger.error("error adding certificates to signature generator", (Throwable)e);
            throw new CryptoException("CMS error", e);
        }
        catch (IOException e) {
            logger.error("error establishing signature generator wrapper around output stream", (Throwable)e);
            throw new CryptoException("Error establishing signature generator wrapper around output stream", e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        logger.trace("writing 1 byte to stream");
        this.stream.write(b);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        logger.trace("writing {} bytes to stream", (Object)bytes.length);
        this.stream.write(bytes);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        logger.trace("writing {} bytes at offset {} to stream", (Object)length, (Object)offset);
        this.stream.write(bytes, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        super.close();
    }
}

