/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.operations.verify.pdf;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfPKCS7;
import com.itextpdf.text.pdf.PdfReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import org.dihedron.core.License;
import org.dihedron.crypto.KeyRing;
import org.dihedron.crypto.exceptions.CryptoException;
import org.dihedron.crypto.operations.verify.Verifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class PDFVerifier
extends Verifier {
    private static Logger logger = LoggerFactory.getLogger(PDFVerifier.class);
    private KeyRing keyring;

    public PDFVerifier(String alias, KeyRing keyring, Provider provider) throws CryptoException {
        this.keyring = keyring;
        logger.trace("PdfSigner initialised");
    }

    @Override
    public boolean verify(byte[] signed) throws CryptoException {
        return this.verify(signed, null);
    }

    @Override
    public boolean verify(byte[] signed, byte[] data) throws CryptoException {
        boolean verified = false;
        try {
            PdfReader reader = new PdfReader(signed);
            AcroFields af = reader.getAcroFields();
            ArrayList names = af.getSignatureNames();
            for (String name : names) {
                logger.debug("signature name: {}", (Object)name);
                logger.debug("signature covers whole document: {}", (Object)af.signatureCoversWholeDocument(name));
                logger.debug("document revision: {} of {}", (Object)af.getRevision(name), (Object)af.getTotalRevisions());
                PdfPKCS7 pk = af.verifySignature(name);
                Calendar cal = pk.getSignDate();
                Certificate[] pkc = pk.getCertificates();
                logger.debug("subject: {}", (Object)PdfPKCS7.getSubjectFields((X509Certificate)pk.getSigningCertificate()));
                logger.debug("revision modified: {}", (Object)(!pk.verify() ? 1 : 0));
                Object[] fails = PdfPKCS7.verifyCertificates((Certificate[])pkc, (KeyStore)this.keyring.getKeyStore(), null, (Calendar)cal);
                if (fails == null) {
                    logger.debug("certificates verified against the KeyStoreHelper");
                    verified = true;
                    continue;
                }
                logger.warn("certificate failed: {}", fails[1]);
                verified = false;
            }
        }
        catch (IOException e) {
            throw new CryptoException("I/O exception while verifying the signature", e);
        }
        catch (SignatureException e) {
            throw new CryptoException("Signature exception while verifying the signature", e);
        }
        return verified;
    }

    @Override
    public boolean verify(InputStream signed) throws CryptoException {
        return false;
    }
}

