/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.operations.verify.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.dihedron.core.License;
import org.dihedron.crypto.exceptions.CryptoException;
import org.dihedron.crypto.operations.verify.Verifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class PKCS7Verifier
extends Verifier {
    private static Logger logger = LoggerFactory.getLogger(PKCS7Verifier.class);

    @Override
    public boolean verify(InputStream signed) throws CryptoException {
        boolean result = true;
        try {
            CMSSignedDataParser parser = new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build(), signed);
            parser.getSignedContent().drain();
            Store store = parser.getCertificates();
            for (Object signer : parser.getSignerInfos().getSigners()) {
                for (Object object : store.getMatches((Selector)((SignerInformation)signer).getSID())) {
                    X509CertificateHolder holder = (X509CertificateHolder)object;
                    logger.trace("verifying signer '{}'", (Object)holder.getSubject());
                    result = result && ((SignerInformation)signer).verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(holder));
                    logger.trace("verify returns: {}", (Object)result);
                }
            }
            logger.trace("data {} verified", (Object)(result ? "was" : "was not"));
            return result;
        }
        catch (IOException | CertificateException | CMSException | OperatorCreationException e) {
            throw new CryptoException("error verifying the signature in streaming mode", e);
        }
    }

    @Override
    public boolean verify(byte[] signed) throws CryptoException {
        try {
            return this.verify(new CMSSignedData(signed), null);
        }
        catch (CMSException e) {
            logger.error("error creating CMSSignedData object", (Throwable)e);
            throw new CryptoException("Error creating CMSSignedData object", e);
        }
    }

    @Override
    public boolean verify(byte[] signed, byte[] data) throws CryptoException {
        try {
            return this.verify(new CMSSignedData(signed), data);
        }
        catch (CMSException e) {
            logger.error("error creating CMSSignedData object", (Throwable)e);
            throw new CryptoException("Error creating CMSSignedData object", e);
        }
    }

    private boolean verify(CMSSignedData signed, byte[] data) throws CryptoException {
        try {
            logger.debug("starting CMSSignedData verification ... ");
            SignerInformationStore signers = signed.getSignerInfos();
            Store certificates = signed.getCertificates();
            logger.debug("{} signers found", (Object)signers.getSigners().size());
            for (SignerInformation signer : signers.getSigners()) {
                logger.debug("{} certificates found for signer '{}'", (Object)certificates.getMatches((Selector)signer.getSID()).size(), (Object)signer.getSID());
                for (Object certificate : certificates.getMatches((Selector)signer.getSID())) {
                    if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build((X509CertificateHolder)certificate))) {
                        logger.info("signature verified for signer '{}'", (Object)signer.getSID());
                        continue;
                    }
                    logger.error("signature verification failed for signer '{}'", (Object)signer.getSID());
                    return false;
                }
            }
            logger.info("all signatures successfully verified");
            return true;
        }
        catch (OperatorCreationException e) {
            logger.error("error creating operator", (Throwable)e);
            throw new CryptoException("Error creating operator", e);
        }
        catch (CertificateException e) {
            logger.error("invalid certificate", (Throwable)e);
            throw new CryptoException("Invalid certificate", e);
        }
        catch (CMSException e) {
            logger.error("CMS error", (Throwable)e);
            throw new CryptoException("CMS error", e);
        }
    }
}

