/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers;

import java.security.Provider;
import org.dihedron.core.License;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class AutoCloseableProvider
extends Provider
implements AutoCloseable {
    private static final long serialVersionUID = -846600572294464148L;
    private static final Logger logger = LoggerFactory.getLogger(AutoCloseableProvider.class);
    protected Provider provider;

    public AutoCloseableProvider(Provider provider) {
        super(provider.getName(), provider.getVersion(), provider.getInfo());
        this.provider = provider;
    }

    @Override
    public String getName() {
        String name = this.provider != null ? this.provider.getName() : null;
        logger.trace("returning provider name: '{}'", (Object)name);
        return name;
    }

    @Override
    public String getInfo() {
        return this.provider != null ? this.provider.getInfo() : null;
    }

    @Override
    public double getVersion() {
        return this.provider != null ? Double.valueOf(this.provider.getVersion()) : null;
    }

    @Override
    public void clear() {
        if (this.provider != null) {
            this.provider.clear();
        }
    }

    @Override
    public void close() {
    }

    public Provider getWrappedProvider() {
        return this.provider;
    }
}

