/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.mscapi;

import java.security.Provider;
import org.dihedron.core.License;
import org.dihedron.crypto.exceptions.ProviderException;
import org.dihedron.crypto.exceptions.SmartCardException;
import org.dihedron.crypto.providers.AutoCloseableProvider;
import org.dihedron.crypto.providers.ProviderFactory;
import org.dihedron.crypto.providers.mscapi.MicrosoftTraits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public final class MicrosoftProvider
extends ProviderFactory<MicrosoftTraits> {
    private static final Logger logger = LoggerFactory.getLogger(MicrosoftProvider.class);

    @Override
    public AutoCloseableProvider getProvider(MicrosoftTraits traits) throws ProviderException {
        try {
            Class<?> clazz = Class.forName("sun.security.mscapi.SunMSCAPI");
            return new AutoCloseableProvider((Provider)clazz.newInstance());
        }
        catch (InstantiationException e) {
            logger.error("error invoking Sun PKCS#11 constructor", (Throwable)e);
            throw new SmartCardException("error invoking Sun PKCS#11 constructor", e);
        }
        catch (IllegalAccessException e) {
            logger.error("error invoking inaccessible Sun PKCS#11 constructor", (Throwable)e);
            throw new SmartCardException("error invoking inaccessible Sun PKCS#11 constructor", e);
        }
        catch (ClassNotFoundException e) {
            logger.error("Microsoft CryptoAPI supporting class ot found in classpath", (Throwable)e);
            throw new SmartCardException("Microsoft CryptoAPI supporting class ot found in classpath", e);
        }
    }
}

