/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.pkcs12;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.dihedron.core.License;
import org.dihedron.crypto.KeyRing;
import org.dihedron.crypto.exceptions.CryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class PKCS12KeyRing
extends KeyRing {
    private static final Logger logger = LoggerFactory.getLogger(PKCS12KeyRing.class);

    public PKCS12KeyRing(String pkcs12, String password) throws CryptoException {
        this(new File(pkcs12), password);
    }

    public PKCS12KeyRing(File pkcs12, String password) throws CryptoException {
        try (FileInputStream stream = new FileInputStream(pkcs12);){
            if (this.keystore != null) {
                logger.info("reopening key store, need to close previous reference first");
                this.close();
            }
            logger.info("loading PKCS#12 keystore from '{}'...", (Object)pkcs12.getCanonicalPath());
            this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            logger.info("... keystore for PKCS#12 provider retrieved");
            this.keystore.load(null, password != null ? password.toCharArray() : null);
            logger.info("... keystore for PKCS#12 provider logged into");
        }
        catch (KeyStoreException e) {
            logger.error("error accessing the keystore", (Throwable)e);
            throw new CryptoException("error accessing the keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("invalid algorithm specified in keystore access", (Throwable)e);
            throw new CryptoException("invalid algorithm specified in keystore access", e);
        }
        catch (CertificateException e) {
            logger.error("error accessing the certificate", (Throwable)e);
            throw new CryptoException("error accessing the certificate", e);
        }
        catch (IOException e) {
            logger.error("I/O exception while accessing the keystore", (Throwable)e);
            throw new CryptoException("I/O exception accessing the keystore", e);
        }
    }

    @Override
    public void close() {
    }
}

