/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.smartcard;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.dihedron.core.License;
import org.dihedron.core.os.Addressing;
import org.dihedron.core.os.OperatingSystem;
import org.dihedron.core.os.Platform;
import org.dihedron.core.os.files.FileFinder;
import org.dihedron.core.os.modules.ImageFile;
import org.dihedron.core.os.modules.ImageFileParser;
import org.dihedron.core.os.modules.ImageParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public final class PCSC {
    private static final Logger logger = LoggerFactory.getLogger(PCSC.class);
    private static Map<Platform, String[]> paths = new HashMap<Platform, String[]>();

    public static void load() {
        Platform platform = Platform.getCurrent();
        block1 : switch (platform.getOperatingSystem()) {
            case WINDOWS: {
                logger.trace("no need to initialise the PC/SC subsystem on Windows");
                if (platform.getAddressing() != Addressing.SIZE_64) break;
                logger.warn("64-bits Windows is not a supported platform");
                break;
            }
            case LINUX: {
                ImageFileParser parser = ImageFileParser.makeParser((ImageFile.Format)ImageFile.Format.ELF);
                for (File file : FileFinder.findFile((String)"libpcsclite.*", (boolean)true, (String[])paths.get(platform))) {
                    try {
                        ImageFile module = parser.parse(file);
                        logger.trace("module: {}", (Object)module.toJSON());
                        if (module.getAddressing() != platform.getAddressing() || module.getOperatingSystem() != OperatingSystem.LINUX && module.getOperatingSystem() != OperatingSystem.SYSTEM_V) continue;
                        logger.info("making libpcsclite accessible from file at {}", (Object)file.getCanonicalPath());
                        System.setProperty("sun.security.smartcardio.library", file.getCanonicalPath());
                        break block1;
                    }
                    catch (IOException | ImageParseException e) {
                        logger.error("error parsing image at " + file.getAbsolutePath(), e);
                    }
                }
                break;
            }
            default: {
                logger.trace("unsupported platform");
            }
        }
    }

    private PCSC() {
    }

    static {
        paths.put(Platform.LINUX_32, new String[]{"/lib/i386-linux-gnu/", "/usr/local/lib/"});
        paths.put(Platform.LINUX_64, new String[]{"/lib/x86_64-linux-gnu/", "/usr/local/lib/"});
    }
}

