/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.smartcard;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.dihedron.core.License;
import org.dihedron.crypto.KeyRing;
import org.dihedron.crypto.exceptions.CryptoException;
import org.dihedron.crypto.exceptions.InvalidPinException;
import org.dihedron.crypto.exceptions.LockedPinException;
import org.dihedron.crypto.providers.smartcard.SmartCardProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class SmartCardKeyRing
extends KeyRing {
    private static final Logger logger = LoggerFactory.getLogger(SmartCardKeyRing.class);
    private static final String SUN_PKCS11_KEYSTORE_TYPE = "PKCS11";

    public SmartCardKeyRing(Provider provider, String password) throws InvalidPinException, LockedPinException, CryptoException {
        try {
            if (this.keystore != null) {
                logger.info("reopening key store, need to close previous reference first");
                this.close();
            }
            logger.info("getting the keystore for PKCS#11 provider '{}'...", (Object)(provider != null ? provider.getName() : "<null>"));
            this.keystore = KeyStore.getInstance(SUN_PKCS11_KEYSTORE_TYPE, provider instanceof SmartCardProvider ? ((SmartCardProvider)provider).getWrappedProvider() : provider);
            logger.info("... keystore for PKCS#11 provider '{}' retrieved", (Object)provider.getName());
            this.keystore.load(null, password != null ? password.toCharArray() : null);
            logger.info("... keystore for PKCS#11 provider '{}' logged into", (Object)provider.getName());
        }
        catch (KeyStoreException e) {
            logger.error("error accessing keystore from provider '" + provider.getName() + "'", (Throwable)e);
            throw new CryptoException("error accessing the keystore on provider '" + provider.getName() + "'", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("non existing algorithm accessing keystore from provider '" + provider.getName() + "'", (Throwable)e);
            throw new CryptoException("non existing algorithm accessing the keystore on provider '" + provider.getName() + "'", e);
        }
        catch (CertificateException e) {
            logger.error("certificate error accessing keystore from provider '" + provider.getName() + "'", (Throwable)e);
            throw new CryptoException("certificate error accessing the keystore on provider '" + provider.getName() + "'", e);
        }
        catch (IOException e) {
            LoginException cause;
            if (e.getCause() != null && e.getCause() instanceof FailedLoginException) {
                FailedLoginException cause2 = (FailedLoginException)e.getCause();
                logger.error("cannot login to smart card, message: '" + cause2.getCause().getMessage() + "'", e.getCause());
                if (cause2.getCause() != null && "CKR_PIN_INCORRECT".equalsIgnoreCase(cause2.getCause().getMessage())) {
                    logger.error("the smart card PIN is incorrect");
                    throw new InvalidPinException("error logging on to smart card: invalid PIN", cause2);
                }
            } else if (e.getCause() != null && e.getCause() instanceof LoginException && (cause = (LoginException)e.getCause()).getCause() != null && "CKR_PIN_LOCKED".equalsIgnoreCase(cause.getCause().getMessage())) {
                logger.error("the smart card PIN is locked");
                throw new LockedPinException("error logging on to smart card: PIN locked", cause);
            }
            logger.error("communication error accessing keystore from provider '" + provider.getName() + "'", (Throwable)e);
            throw new CryptoException("communication error accessing the key store on provider '" + provider.getName() + "'", e);
        }
    }

    @Override
    public void close() {
        logger.trace("nothing to do to release PKCS#11 key store");
    }
}

