/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.smartcard.discovery;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import org.dihedron.core.License;
import org.dihedron.core.filters.Filter;
import org.dihedron.crypto.exceptions.SmartCardException;
import org.dihedron.crypto.providers.smartcard.discovery.ATR;
import org.dihedron.crypto.providers.smartcard.discovery.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public final class Readers {
    private static final Logger logger = LoggerFactory.getLogger(Readers.class);

    public static Collection<Reader> enumerate() throws SmartCardException {
        ArrayList<Reader> readers = new ArrayList<Reader>();
        try {
            int slot = 0;
            for (CardTerminal terminal : TerminalFactory.getInstance("PC/SC", null).terminals().list()) {
                ATR atr = null;
                String name = terminal.getName();
                try {
                    logger.trace("connecting to smart card reader '{}' at slot {}...", (Object)name, (Object)slot);
                    if (terminal.isCardPresent()) {
                        logger.trace("... smart card available in reader");
                        atr = new ATR(terminal.connect("*").getATR().getBytes());
                        logger.trace("... smart card in reader has ATR '{}'", (Object)atr);
                    }
                    readers.add(new Reader(slot, name, atr));
                }
                catch (CardException e) {
                    logger.warn("error accessing reader '" + name + "', it will be ignored", (Throwable)e);
                }
                ++slot;
            }
        }
        catch (CardException e) {
            logger.error("error accessing the smart card reader (terminal) factory", (Throwable)e);
            throw new SmartCardException("error accessing the smart card reader (terminal) factory", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("error opening PC/SC provider: it may not be available", (Throwable)e);
            throw new SmartCardException("error opening PC/SC provider: it may not be available", e);
        }
        return readers;
    }

    public static Collection<Reader> enumerate(Filter<Reader> filter) throws SmartCardException {
        Collection<Reader> readers = Readers.enumerate();
        return Filter.apply(filter, readers);
    }

    private Readers() {
    }
}

