/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.providers.smartcard.discovery;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.dihedron.core.License;
import org.dihedron.core.os.Platform;
import org.dihedron.crypto.providers.smartcard.discovery.ATR;
import org.dihedron.crypto.providers.smartcard.discovery.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public class SmartCard {
    private static final Logger logger = LoggerFactory.getLogger(SmartCard.class);
    private ATR atr;
    private String description;
    private String manufacturer;
    private Map<Platform, Driver> drivers = new HashMap<Platform, Driver>();

    SmartCard(ATR atr) {
        logger.trace("creating a new smartcard for ATR '{}'", (Object)atr);
        this.atr = atr;
    }

    public ATR getATR() {
        return this.atr;
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        logger.trace("setting description to '{}'", (Object)description);
        this.description = description;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    void addDriver(Driver driver) {
        if (driver != null) {
            logger.info("adding new driver for platform '{}' to smartcard '{}'", (Object)driver.getPlatform(), (Object)this.atr);
            this.drivers.put(driver.getPlatform(), driver);
        }
    }

    public File getDriver(Platform platform) {
        Driver driver = this.drivers.get(platform);
        if (driver != null) {
            return driver.find();
        }
        logger.error("no supporting driver found for smartcard '{}' (SMARTCARD_ATR: {}) on platform '{}'", new Object[]{this.description, this.atr, platform});
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("smartcard: {\n");
        buffer.append("\tatr          : '").append(this.atr).append("',\n");
        buffer.append("\tdescription  : '").append(this.description).append("',\n");
        buffer.append("\tmanufacturer : '").append(this.manufacturer).append("',\n");
        buffer.append("\tdrivers      : [\n");
        for (Map.Entry<Platform, Driver> driver : this.drivers.entrySet()) {
            buffer.append("\t\t").append(driver.getValue().toString()).append("\n");
        }
        buffer.append("\t]\n");
        buffer.append("}");
        return buffer.toString();
    }
}

