/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.demo.portlets.portlet1.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.dihedron.commons.utils.Strings;
import org.dihedron.commons.utils.Types;
import org.dihedron.demo.portlets.portlet1.actions.Portlet1ValidationHandler;
import org.dihedron.strutlets.annotations.Action;
import org.dihedron.strutlets.annotations.In;
import org.dihedron.strutlets.annotations.Invocable;
import org.dihedron.strutlets.annotations.Out;
import org.dihedron.strutlets.annotations.Result;
import org.dihedron.strutlets.annotations.Scope;
import org.dihedron.strutlets.aop.$;
import org.dihedron.strutlets.exceptions.InvalidPhaseException;
import org.hibernate.validator.constraints.Email;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action
public class ProxiedAction {
    private static final Logger logger = LoggerFactory.getLogger(ProxiedAction.class);

    @Invocable(idempotent=true, results={@Result(value="success", renderer="jsp", data="/html/portlet1/view.jsp")})
    public String render(@Out(value="friendsAttribute", scope=Scope.REQUEST) $<Set<List<Map<String, Vector<String>>>>> friends, @Out(value="descriptionAttribute", scope=Scope.PORTLET) $<String> description, @Out(value="ageAttribute", scope=Scope.APPLICATION) $<Integer> age, @Out(value="genderAttribute", scope=Scope.APPLICATION) $<Boolean> gender) {
        logger.debug("initialising view, storing parameters into session");
        friends.set(new HashSet());
        description.set((Object)"a very good person");
        gender.set((Object)true);
        age.set((Object)100);
        return "success";
    }

    @Invocable(idempotent=true, results={@Result(value="success", renderer="jsp", data="/html/portlet1/result.jsp"), @Result(value="invalid_input", renderer="jsp", data="/html/portlet1/view_on_input_errors.jsp")}, validator=Portlet1ValidationHandler.class)
    @Pattern(regexp="^sucCess$|^error$")
    public String dumpInputs(@In(value="nameParameter", scopes={Scope.FORM}) @Size(min=3, max=20, message="error-name-key") String name, @In(value="surnameParameter", scopes={Scope.FORM}) @Size(min=3, max=20, message="error-surname-key") String surname, @In(value="phoneParameter", scopes={Scope.FORM}) @Pattern(regexp="^\\d{2}-\\d{3}-\\d{5}$", message="error-phone-key") String phone, @In(value="emailParameter", scopes={Scope.FORM}) @Email(message="error-email-key") String email, @In(value="lovesCheckbox", scopes={Scope.FORM}) String[] loves, @In(value="friendsAttribute", scopes={Scope.REQUEST}) Set<List<Map<String, Vector<String>>>> friends, @In(value="descriptionAttribute", scopes={Scope.PORTLET}) String description, @In(value="ageAttribute", scopes={Scope.APPLICATION}) @Min(value=10L) @Max(value=120L) Integer age, @In(value="genderAttribute", scopes={Scope.APPLICATION}) Boolean gender, String aString, double aDouble, @Out(value="result", scope=Scope.RENDER) $<String> result) throws InvalidPhaseException {
        logger.debug("dumping input parameters from session & form");
        StringBuilder buffer = new StringBuilder("{\n");
        buffer.append("\t'name' : '").append(name).append("' (").append(Types.getAsStringFor((Object)name)).append("),\n");
        buffer.append("\t'surname' : '").append(surname).append("' (").append(Types.getAsStringFor((Object)surname)).append("),\n");
        buffer.append("\t'phone' : '").append(phone).append("' (").append(Types.getAsStringFor((Object)phone)).append("),\n");
        buffer.append("\t'email' : '").append(email).append("' (").append(Types.getAsStringFor((Object)email)).append("),\n");
        buffer.append("\t'loves' : [").append(Strings.join((String)", ", (Object[])loves)).append("] (").append(Types.getAsStringFor((Object)loves)).append("),\n");
        buffer.append("\t'friends' : '").append(friends).append("' (").append(Types.getAsStringFor(friends)).append("),\n");
        buffer.append("\t'description' : '").append(description).append("' (").append(Types.getAsStringFor((Object)description)).append("),\n");
        buffer.append("\t'age' : '").append(age).append("' (").append(Types.getAsStringFor((Object)age)).append("),\n");
        buffer.append("\t'gender' : '").append(gender).append("' (").append(Types.getAsStringFor((Object)gender)).append("),\n");
        buffer.append("}");
        result.set((Object)buffer.toString());
        return "success";
    }
}

