/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.demo.portlets.portlet1.actions;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.validation.ConstraintViolation;
import org.dihedron.strutlets.ActionContext;
import org.dihedron.strutlets.validation.ValidationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Portlet1ValidationHandler
implements ValidationHandler {
    private static final Logger logger = LoggerFactory.getLogger(Portlet1ValidationHandler.class);

    public String onParametersViolations(String action, String method, Set<ConstraintViolation<?>> violations) {
        SessionMessages.add((PortletRequest)ActionContext.getPortletRequest(), (String)(ActionContext.getPortletName() + ".hideDefaultErrorMessage"));
        for (ConstraintViolation<?> violation : violations) {
            logger.warn("{}!{}: violation on parameter value '{}' will show error message with key '{}'", new Object[]{action, method, violation.getInvalidValue(), violation.getMessage()});
            SessionErrors.add((PortletRequest)ActionContext.getPortletRequest(), (String)violation.getMessage());
        }
        return "invalid_input";
    }

    public String onResultViolations(String action, String method, Set<ConstraintViolation<?>> violations) {
        for (ConstraintViolation<?> violation : violations) {
            logger.warn("{}!{}: violation on return value {}: {}", new Object[]{action, method, violation.getInvalidValue(), violation.getMessage()});
        }
        return null;
    }

    public String onModelViolations(String action, String method, int index, Class<?> model, Set<ConstraintViolation<?>> violations) {
        SessionMessages.add((PortletRequest)ActionContext.getPortletRequest(), (String)(ActionContext.getPortletName() + ".hideDefaultErrorMessage"));
        for (ConstraintViolation<?> violation : violations) {
            logger.warn("{}!{}: violation on model bean {} (no. {}), value {}: {}", new Object[]{action, method, model.getSimpleName(), index, violation.getInvalidValue(), violation.getMessage()});
            SessionErrors.add((PortletRequest)ActionContext.getPortletRequest(), (String)violation.getMessage());
        }
        return null;
    }
}

