/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.strutlets.containers.web.jbossas;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.jar.JarFile;
import org.dihedron.strutlets.containers.web.ApplicationServer;
import org.jboss.vfs.VirtualFile;
import org.reflections.ReflectionsException;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JBossAS
implements ApplicationServer {
    private static final Logger logger = LoggerFactory.getLogger(JBossAS.class);

    public boolean initialise() {
        logger.info("initialising JBoss 7.x runtime environment...");
        Vfs.addDefaultURLTypes((Vfs.UrlType)new Vfs.UrlType(){

            public boolean matches(URL url) {
                return url.getProtocol().equals("vfs");
            }

            public Vfs.Dir createDir(URL url) {
                VirtualFile content;
                try {
                    content = (VirtualFile)url.openConnection().getContent();
                }
                catch (IOException e) {
                    logger.error("could not open url connection as VirtualFile [{}]", (Object)url);
                    throw new ReflectionsException("could not open url connection as VirtualFile [" + url + "]", (Throwable)e);
                }
                Vfs.Dir dir = null;
                try {
                    dir = this.createDir(new File(content.getPhysicalFile().getParentFile(), content.getName()));
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (dir == null) {
                    try {
                        dir = this.createDir(content.getPhysicalFile());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return dir;
            }

            Vfs.Dir createDir(File file) {
                try {
                    return file.exists() && file.canRead() ? (file.isDirectory() ? new SystemDir(file) : new ZipDir(new JarFile(file))) : null;
                }
                catch (IOException e) {
                    logger.error("I/O exception caught", (Throwable)e);
                    return null;
                }
            }
        });
        return true;
    }

    public void cleanup() {
    }
}

