/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.strutlets.containers.portlet.liferay;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dihedron.strutlets.plugins.Probe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LiferayProbe
implements Probe {
    private static final Logger logger = LoggerFactory.getLogger(LiferayProbe.class);

    public boolean isSupportedEnvironment() {
        boolean supported = false;
        try {
            logger.trace("trying to load Liferay specific classes");
            Class<?> clazz = Class.forName("com.liferay.portal.kernel.util.ReleaseInfo");
            Method getName = clazz.getMethod("getName", new Class[0]);
            String name = (String)getName.invoke(null, new Object[0]);
            Method getVersion = clazz.getMethod("getVersion", new Class[0]);
            String version = (String)getVersion.invoke(null, new Object[0]);
            logger.trace("container name: '{}', version: '{}'", (Object)name, (Object)version);
            supported = name.startsWith(this.getReferenceName()) && version.startsWith(this.getReferenceVersion());
        }
        catch (ClassNotFoundException e) {
            logger.warn("not running on Liferay Portal, please remove this plugin from your deployment to stop seeing this message");
        }
        catch (IllegalAccessException e) {
            logger.error("error accessing class for server information retrieval", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error("no method found on server info class", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("security violation accessing server info class method", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("invalid argument invoking server info class method", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("error invoking server info class method", (Throwable)e);
        }
        return supported;
    }

    protected abstract String getReferenceName();

    protected abstract String getReferenceVersion();
}

