/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.strutlets.containers.web.tomcat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dihedron.strutlets.plugins.Probe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TomcatProbe
implements Probe {
    private static final Logger logger = LoggerFactory.getLogger(TomcatProbe.class);

    public boolean isSupportedEnvironment() {
        boolean supported = false;
        try {
            logger.trace("trying to load Apache Tomcat specific classes");
            Class<?> clazz = Class.forName("org.apache.catalina.util.ServerInfo");
            Method getServerInfo = clazz.getMethod("getServerInfo", new Class[0]);
            String identification = (String)getServerInfo.invoke(null, new Object[0]);
            Method getServerNumber = clazz.getMethod("getServerNumber", new Class[0]);
            String number = (String)getServerNumber.invoke(null, new Object[0]);
            logger.trace("server info: '{}', server number: '{}'", (Object)identification, (Object)number);
            supported = identification.startsWith(this.getReferenceName()) && number.startsWith(this.getReferenceVersion());
        }
        catch (ClassNotFoundException e) {
            logger.warn("not running on Apache Tomcat, please remove this plugin from your deployment to stop seeing this message");
        }
        catch (IllegalAccessException e) {
            logger.error("error accessing class for server information retrieval", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error("no method found on server info class", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("security violation accessing server info class method", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("invalid argument invoking server info class method", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("error invoking server info class method", (Throwable)e);
        }
        return supported;
    }

    protected abstract String getReferenceName();

    protected abstract String getReferenceVersion();
}

