/*
 * Decompiled with CFR 0.152.
 */
package jpower.core;

import java.util.concurrent.TimeUnit;
import jpower.core.Condition;
import jpower.core.utils.ThreadUtils;

public class ConditionalExecutor {
    private final Runnable task;

    public ConditionalExecutor(Runnable task) {
        this.task = task;
    }

    public void until(Condition condition) {
        while (condition.inverted()) {
            this.task.run();
        }
    }

    public void when(Condition condition) {
        while (condition.check()) {
            this.task.run();
        }
    }

    public void intervalUntil(long amount, TimeUnit unit, Condition condition) {
        while (condition.inverted()) {
            this.task.run();
            ThreadUtils.sleep(unit.toMillis(amount));
        }
    }

    public void intervalWhen(long amount, TimeUnit unit, Condition condition) {
        while (condition.check()) {
            this.task.run();
            ThreadUtils.sleep(unit.toMillis(amount));
        }
    }
}

