/*
 * Decompiled with CFR 0.152.
 */
package jpower.event;

import java.util.ArrayList;
import java.util.List;
import jpower.core.Wrapper;
import jpower.event.DeadEvent;
import jpower.event.EventHandler;
import jpower.event.IEventBus;
import jpower.event.RegisteredHandler;

public class EventBus
implements IEventBus {
    protected final List<RegisteredHandler> handlers = new ArrayList<RegisteredHandler>();

    @Override
    public void register(Object object) {
        this.handlers.add(new RegisteredHandler(object).setAnnotationType(EventHandler.class).registerMethods());
    }

    @Override
    public boolean unregister(Object object) {
        for (RegisteredHandler rh : this.handlers) {
            if (rh.getObject() != object) continue;
            this.handlers.remove(rh);
            return true;
        }
        return false;
    }

    @Override
    public void post(Object event) {
        Wrapper<Boolean> didRun = new Wrapper<Boolean>(false);
        this.handlers.forEach(handler -> {
            if (handler.executeEvent(event)) {
                didRun.set(true);
            }
        });
        if (!DeadEvent.class.isAssignableFrom(event.getClass()) && !didRun.get().booleanValue()) {
            this.post(new DeadEvent(event));
        }
    }
}

