/*
 * Decompiled with CFR 0.152.
 */
package jpower.irc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpower.core.utils.IOUtils;
import jpower.event.EventBus;
import jpower.event.EventHandler;
import jpower.irc.Channel;
import jpower.irc.InviteEvent;
import jpower.irc.JoinEvent;
import jpower.irc.MessageEvent;
import jpower.irc.MotdEvent;
import jpower.irc.PingEvent;
import jpower.irc.ReadyEvent;
import jpower.irc.Sendable;
import jpower.irc.TopicAddEvent;
import jpower.irc.TopicChangeEvent;
import jpower.irc.User;
import jpower.irc.WhoisObject;

public class PowerIrc {
    private static final Pattern PATTERN = Pattern.compile("^(:(?<prefix>\\S+) )?(?<command>\\S+)( (?!:)(?<params>.+?))?( :(?<trail>.+))?$");
    private static final Pattern HOSTMASK = Pattern.compile("[!@]");
    private EventBus eventBus;
    private Socket socket;
    private PrintWriter writer;
    private BufferedReader reader;
    private Thread worker;
    private String username;
    private String nickname;
    private String realname;
    private String server;
    private int port;
    private User me;
    private boolean ready;
    private List<String> motd;
    private Map<String, User> users;
    private Map<String, Channel> channels;
    private List<String> init_channels;

    public PowerIrc(String username, String nickname, String realname, String server, int port, List<String> init_channels) {
        this.username = username;
        this.nickname = nickname;
        this.realname = realname;
        this.server = server;
        this.port = port;
        this.me = new User(this, username, nickname);
        this.eventBus = new EventBus();
        this.eventBus.register(this);
        this.motd = new ArrayList<String>();
        this.users = new HashMap<String, User>();
        this.channels = new HashMap<String, Channel>();
        this.init_channels = init_channels;
    }

    public void connect() {
        try {
            this.socket = new Socket(this.server, this.port);
            this.writer = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.reader = IOUtils.createBufferedReader(this.socket.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.worker = new Reader();
        this.worker.start();
        this.nick(this.nickname);
        this.user(this.username, this.realname);
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void writeline(String line) {
        this.writer.write(line + "\r\n");
        this.writer.flush();
    }

    public String readline() {
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void nick(String nick) {
        this.writeline("NICK " + nick);
        this.nickname = nick;
        this.me.setNickname(nick);
    }

    private void user(String username, String realname) {
        this.writeline("USER " + username + " 8 * :" + realname);
    }

    public void join(String channel) {
        this.writeline("JOIN " + channel);
        this.eventBus.post(new JoinEvent(channel));
    }

    public void part(String channel) {
        this.writeline("PART " + channel);
    }

    private void joinChannels() {
        for (String channel : this.init_channels) {
            this.join(channel);
        }
    }

    public void privmsg(User user, String message) {
        this.writeline("PRIVMSG " + user.getNickname() + " :" + message);
    }

    public void privmsg(Channel channel, String message) {
        this.writeline("PRIVMSG " + channel.getName() + " :" + message);
    }

    public void whois(String user) {
        this.writeline("WHOIS " + user);
    }

    public WhoisObject parseWhoisQuery(String params, String trail) {
        String line = params + " " + trail;
        String[] split = line.split(" ", 5);
        String nickname = split[1];
        String username = split[2];
        String hostname = split[3];
        String realname = split[4].substring(2);
        return new WhoisObject(nickname, username, hostname, realname);
    }

    public void notice(User user, String message) {
        this.writeline("NOTICE " + user.getNickname() + " :" + message);
    }

    @EventHandler
    public void ready(ReadyEvent event) {
        this.joinChannels();
    }

    @EventHandler
    public void msg(MessageEvent event) {
        System.out.println("[" + event.getSender().getName() + "] -> [" + event.getTarget().getName() + "] " + event.getMessage());
    }

    @EventHandler
    public void ping(PingEvent event) {
        this.writeline("PONG :" + event.getTrail());
    }

    @EventHandler
    public void topicAdd(TopicAddEvent event) {
        event.getChannel().setTopic(event.getTopic());
    }

    @EventHandler
    public void topicChange(TopicChangeEvent event) {
        event.getChannel().setTopic(event.getNewTopic());
    }

    @EventHandler
    public void invited(InviteEvent event) {
        this.join(event.getChannel());
    }

    public boolean isHostmask(String input) {
        return input.contains("!") && input.contains("@");
    }

    public boolean isServer(String input) {
        return !input.contains("!") && !input.contains("@") && input.contains(".");
    }

    public User parseHostmask(String hostmask) {
        String[] parts = HOSTMASK.split(hostmask);
        return new User(this, parts[1], parts[0], parts[2]);
    }

    public void updateUser(WhoisObject whois) {
        if (this.users.containsKey(whois.getNickname())) {
            this.users.get(whois.getUsername()).setNickname(whois.getNickname());
        } else {
            this.users.put(whois.getNickname(), new User(this, whois.getUsername(), whois.getNickname(), whois.getHostname(), whois.getRealname()));
        }
    }

    public class Reader
    extends Thread {
        @Override
        public void run() {
            String read;
            while ((read = PowerIrc.this.readline()) != null) {
                Matcher matcher = PATTERN.matcher(read);
                matcher.matches();
                String prefix = matcher.group("prefix");
                String command = matcher.group("command");
                String params = matcher.group("params");
                String trail = matcher.group("trail");
                switch (command) {
                    case "PING": {
                        PowerIrc.this.eventBus.post(new PingEvent(trail));
                        break;
                    }
                    case "JOIN": {
                        if (!PowerIrc.this.parseHostmask(prefix).getUsername().substring(1).equals(PowerIrc.this.username)) break;
                        PowerIrc.this.channels.put(params, new Channel(PowerIrc.this, params));
                        break;
                    }
                    case "TOPIC": {
                        String targeta = params;
                        if (!PowerIrc.this.channels.containsKey(targeta)) break;
                        PowerIrc.this.eventBus.post(new TopicChangeEvent((Channel)PowerIrc.this.channels.get(targeta), ((Channel)PowerIrc.this.channels.get(targeta)).getTopic(), trail));
                        break;
                    }
                    case "PRIVMSG": {
                        if (params.equals(PowerIrc.this.username)) {
                            PowerIrc.this.eventBus.post(new MessageEvent(PowerIrc.this.parseHostmask(prefix), PowerIrc.this.me, trail));
                            break;
                        }
                        PowerIrc.this.eventBus.post(new MessageEvent(PowerIrc.this.parseHostmask(prefix), (Sendable)PowerIrc.this.channels.get(params), trail));
                        break;
                    }
                    case "INVITE": {
                        if (PowerIrc.this.channels.containsKey(trail)) break;
                        PowerIrc.this.eventBus.post(new InviteEvent((User)PowerIrc.this.users.get(PowerIrc.this.parseHostmask(prefix)), trail));
                        break;
                    }
                    case "001": {
                        break;
                    }
                    case "005": {
                        String[] supports;
                        for (String s : supports = params.split(" ")) {
                            if (!s.startsWith("CHANTYPES=")) continue;
                            System.out.println("Channel Prefixes: " + s.split("=")[1]);
                        }
                        break;
                    }
                    case "311": {
                        WhoisObject whois = PowerIrc.this.parseWhoisQuery(params, trail);
                        PowerIrc.this.updateUser(whois);
                        break;
                    }
                    case "332": {
                        String target = params.split(" ")[1];
                        if (!PowerIrc.this.channels.containsKey(target)) break;
                        PowerIrc.this.eventBus.post(new TopicAddEvent((Channel)PowerIrc.this.channels.get(target), trail));
                        break;
                    }
                    case "353": {
                        String chan = params.split(" ")[2];
                        if (!PowerIrc.this.channels.containsKey(chan)) break;
                        for (String s : trail.split(" ")) {
                            String real = s.replace("@", "").replace("+", "");
                            Channel channel = (Channel)PowerIrc.this.channels.get(chan);
                            if (real.equals(PowerIrc.this.nickname)) continue;
                            User user = PowerIrc.this.users.containsKey(s) ? (User)PowerIrc.this.users.get(real) : new User(PowerIrc.this, real);
                            if (s.startsWith("@")) {
                                channel.setOp(user);
                            } else if (s.startsWith("+")) {
                                channel.setVoice(user);
                            }
                            channel.addUser(user);
                        }
                        break;
                    }
                    case "366": {
                        break;
                    }
                    case "372": {
                        PowerIrc.this.motd.add(trail);
                        break;
                    }
                    case "375": {
                        break;
                    }
                    case "376": {
                        PowerIrc.this.eventBus.post(new ReadyEvent());
                        PowerIrc.this.eventBus.post(new MotdEvent(PowerIrc.this.motd));
                        break;
                    }
                }
            }
        }
    }
}

