/*
 * Decompiled with CFR 0.152.
 */
package jpower.core;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpower.core.utils.IOUtils;

public class JPower {
    private static final Release release;

    public static Release getRelease() {
        return release;
    }

    static {
        String rawRelease = IOUtils.getResourceAsString(JPower.class, "release.properties");
        Pattern pattern = Pattern.compile("(.*)=(.*)");
        Matcher matcher = pattern.matcher(rawRelease);
        HashMap<String, String> info = new HashMap<String, String>();
        while (matcher.find()) {
            info.put(matcher.group(1), matcher.group(2));
        }
        release = new Release(info);
    }

    public static class Release {
        private final String version;
        private final String commit;

        public Release(Map<String, String> info) {
            this.version = info.get("version");
            this.commit = info.get("commit");
        }

        public String getVersion() {
            return this.version;
        }

        public String getCommit() {
            return this.commit;
        }
    }
}

