/*
 * Decompiled with CFR 0.152.
 */
package jpower.socket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketAddress;
import jpower.core.utils.IOUtils;

public class Client {
    private final Socket socket;
    private final BufferedReader reader;
    private final PrintWriter writer;
    private final ObjectOutputStream objectOut;
    private final ObjectInputStream objectIn;

    public Client(Socket socket) throws IOException {
        this.socket = socket;
        this.reader = IOUtils.createBufferedReader(socket.getInputStream());
        this.writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        this.objectOut = new ObjectOutputStream(socket.getOutputStream());
        this.objectIn = new ObjectInputStream(socket.getInputStream());
    }

    public void write(String text) {
        this.writer.write(text);
        this.writer.flush();
    }

    public void writeObject(Object object) throws IOException {
        this.objectOut.writeObject(object);
        this.objectOut.flush();
    }

    public SocketAddress getRemoteAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public void writeLine(String line) {
        this.write(line + System.lineSeparator());
    }

    public String readLine() throws IOException {
        return this.reader.readLine();
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this.objectIn.readObject();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void disconnect() throws IOException {
        this.socket.close();
    }

    public boolean connected() {
        return this.socket.isConnected();
    }

    public boolean disconnected() {
        return this.socket.isClosed();
    }
}

