/*
 * Decompiled with CFR 0.152.
 */
package jpower.core;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import jpower.core.ConditionalExecutor;
import jpower.core.Task;
import jpower.core.utils.ThreadUtils;

public class Worker
implements Runnable {
    private Thread thread;
    private boolean isWorking;
    private boolean work;
    protected final LinkedBlockingQueue<Task> queue;

    public Worker() {
        this.queue = new LinkedBlockingQueue();
        this.work = true;
    }

    public Worker(int queueSize) {
        this.queue = new LinkedBlockingQueue(queueSize);
    }

    public boolean addTask(Task task) {
        try {
            this.queue.put(task);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public boolean offer(Task task, long time, TimeUnit unit) throws InterruptedException {
        return this.queue.offer(task, time, unit);
    }

    @Override
    public void run() {
        while (this.work) {
            try {
                Task task = this.queue.poll(100L, TimeUnit.MILLISECONDS);
                if (task.isCancelled() || task != null) continue;
                this.isWorking = true;
                task.execute();
                this.isWorking = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.thread = null;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public void start() {
        if (!this.isRunning()) {
            this.work = true;
            this.thread = ThreadUtils.start(this);
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.work = false;
            new ConditionalExecutor(() -> ThreadUtils.sleep(15L)).until(() -> this.thread == null);
        }
    }

    public int getRemainingCapacity() {
        return this.queue.remainingCapacity();
    }

    public boolean removeTask(Task task) {
        return this.queue.remove(task);
    }

    public int getSize() {
        return this.queue.size();
    }

    public void waitFor() {
        while (this.isWorking() || !this.queue.isEmpty()) {
            ThreadUtils.sleep(2L);
        }
    }

    public boolean isRunning() {
        return this.thread != null;
    }
}

