/*
 * Decompiled with CFR 0.152.
 */
package jpower.core.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import jpower.core.utils.ListUtils;

public class FileUtils {
    public static String toString(File file) throws IOException {
        return new String(FileUtils.readBytes(file));
    }

    public static boolean exists(File file) {
        return Files.exists(file.toPath(), new LinkOption[0]);
    }

    public static byte[] readBytes(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static List<String> readLines(File file) throws IOException {
        return Files.readAllLines(file.toPath());
    }

    public static Stream<Path> listFiles(File file) throws IOException {
        return Files.list(file.toPath());
    }

    public static void write(File file, String text) throws IOException {
        FileUtils.write(file, text.getBytes());
    }

    public static void write(File file, List<String> lines) throws IOException {
        FileUtils.write(file, ListUtils.toString(lines));
    }

    public static void write(File file, byte[] input) throws IOException {
        Files.write(file.toPath(), input, new OpenOption[0]);
    }

    public static BufferedReader newReader(File file) throws IOException {
        return Files.newBufferedReader(file.toPath());
    }

    public static BufferedWriter newWriter(File file) throws IOException {
        return Files.newBufferedWriter(file.toPath(), new OpenOption[0]);
    }

    public static void watch(File file, Function<WatchEvent<?>, Boolean> handler, WatchEvent.Kind<?> ... kinds) throws IOException {
        block2: {
            boolean valid;
            WatchService watcher = FileSystems.getDefault().newWatchService();
            Path path = file.toPath();
            WatchKey key = path.register(watcher, kinds);
            do {
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (handler.apply(event).booleanValue()) continue;
                    break block2;
                }
            } while (valid = key.isValid());
        }
    }
}

