/*
 * Decompiled with CFR 0.152.
 */
package jpower.irc;

import java.util.HashMap;
import java.util.Map;
import jpower.irc.PowerIrc;
import jpower.irc.Sendable;
import jpower.irc.User;

public class Channel
implements Sendable {
    private final PowerIrc client;
    private final String name;
    private String topic;
    private Map<String, User> users;
    private Map<String, User> ops;
    private Map<String, User> voices;

    public Channel(PowerIrc client, String name) {
        this.client = client;
        this.name = name;
        this.users = new HashMap<String, User>();
        this.ops = new HashMap<String, User>();
        this.voices = new HashMap<String, User>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void addUser(User user) {
        if (this.users.containsKey(user)) {
            return;
        }
        this.users.put(user.getUsername(), user);
    }

    protected void setOp(User user) {
        if (this.ops.containsKey(user)) {
            return;
        }
        this.ops.put(user.getNickname(), user);
    }

    protected void removeOp(User user) {
        this.ops.remove(user);
    }

    protected void setVoice(User user) {
        try {
            if (this.voices.containsKey(user)) {
                return;
            }
            this.voices.put(user.getNickname(), user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void removeVoice(User user) {
        this.voices.remove(user);
    }

    public void userJoin(User user) {
        if (this.users.containsKey(user)) {
            return;
        }
        this.users.put(user.getUsername(), user);
    }

    public void userPart(User user) {
        this.users.remove(user);
    }

    @Override
    public void message(String message) {
        this.client.privmsg(this, message);
    }

    public Map<String, User> getUsers() {
        return this.users;
    }

    public Map<String, User> getOps() {
        return this.ops;
    }

    public Map<String, User> getVoices() {
        return this.voices;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }
}

