/*
 * Decompiled with CFR 0.152.
 */
package jpower.irc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import jpower.core.utils.IOUtils;
import jpower.irc.User;

public class PowerIrcServer {
    private int port;
    private ServerSocket socket;
    private Map<String, User> users;
    private boolean connected;

    public PowerIrcServer(int port) {
        this.port = port;
        try {
            this.socket = new ServerSocket(port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.connected = true;
        this.users = new HashMap<String, User>();
        Reader reader = new Reader();
        reader.start();
    }

    public class ClientHandler
    extends Thread {
        private Socket client;
        private PrintWriter writer;
        private BufferedReader reader;

        public ClientHandler(Socket client) {
            this.client = client;
            try {
                this.writer = new PrintWriter(new OutputStreamWriter(client.getOutputStream()));
                this.reader = IOUtils.createBufferedReader(client.getInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public String readline() {
            try {
                return this.reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void run() {
            String read;
            while ((read = this.readline()) != null) {
                System.out.println(read);
            }
        }
    }

    public class Reader
    extends Thread {
        @Override
        public void run() {
            while (PowerIrcServer.this.connected) {
                try {
                    Socket client = PowerIrcServer.this.socket.accept();
                    new ClientHandler(client).start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

