/*
 * Decompiled with CFR 0.152.
 */
package jpower.irc.rewrite.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jpower.core.utils.IOUtils;
import jpower.event.EventBus;
import jpower.irc.rewrite.common.Channel;
import jpower.irc.rewrite.common.ServerHostname;
import jpower.irc.rewrite.common.User;

public class PowerIrc {
    private static final Pattern PATTERN = Pattern.compile("^(:(?<prefix>\\S+) )?(?<command>\\S+)( (?!:)(?<params>.+?))?( :(?<trail>.+))?$");
    private static final Pattern HOSTMASK = Pattern.compile("[!@]");
    private EventBus eventBus;
    private Socket socket;
    private PrintWriter writer;
    private BufferedReader reader;
    private Thread worker;
    private String username;
    private String nickname;
    private String realname;
    private ServerHostname server;
    private User me;
    private boolean ready;
    private List<String> motd;
    private Map<String, User> users;
    private Map<String, Channel> channels;
    private List<String> initial_channels;

    protected PowerIrc(String username, String nickname, String realname, ServerHostname server, List<String> initial_channels) {
        this.username = username;
        this.nickname = nickname;
        this.realname = realname;
        this.server = server;
        this.eventBus = new EventBus();
        this.eventBus.register(this);
        this.motd = new ArrayList<String>();
        this.users = new HashMap<String, User>();
        this.channels = new HashMap<String, Channel>();
        this.initial_channels = initial_channels;
    }

    private void connect() {
        try {
            this.socket = new Socket(this.server.getHostname(), this.server.getPort());
            this.writer = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.reader = IOUtils.createBufferedReader(this.socket.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.nick(this.nickname);
        this.user(this.username, this.realname);
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void writeline(String line) {
        this.writer.write(line + "\r\n");
        this.writer.flush();
    }

    public String readline() {
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void nick(String nick) {
        this.writeline("NICK " + nick);
        this.nickname = nick;
    }

    private void user(String username, String realname) {
        this.writeline("USER " + username + " 8 * :" + realname);
    }
}

