/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileReader2;
import htsjdk.samtools.SBIIndexWriter;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeEOFException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class BAMSBIIndexer {
    public static void createIndex(Path bamFile, long granularity) throws IOException {
        Path splittingBaiFile = IOUtil.addExtension((Path)bamFile, (String)".sbi");
        try (SeekablePathStream in = new SeekablePathStream(bamFile);
             OutputStream out = Files.newOutputStream(splittingBaiFile, new OpenOption[0]);){
            BAMSBIIndexer.createIndex((SeekableStream)in, out, granularity);
        }
    }

    public static void createIndex(SeekableStream in, OutputStream out, long granularity) throws IOException {
        long recordStart = BAMSBIIndexer.findVirtualOffsetOfFirstRecordInBam(in);
        BlockCompressedInputStream blockIn = new BlockCompressedInputStream(in);
        Throwable throwable = null;
        try {
            blockIn.seek(recordStart);
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            SBIIndexWriter indexWriter = new SBIIndexWriter(out, granularity);
            try {
                while (true) {
                    recordStart = blockIn.getFilePointer();
                    InputStreamUtils.readFully((InputStream)blockIn, (byte[])byteBuffer.array(), (int)0, (int)4);
                    int blockSize = byteBuffer.getInt(0);
                    indexWriter.processRecord(recordStart);
                    InputStreamUtils.skipFully((InputStream)blockIn, (long)blockSize);
                }
            }
            catch (EOFException e) {
                indexWriter.finish(recordStart, in.length());
                if (blockIn != null) {
                    if (throwable != null) {
                        try {
                            blockIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        blockIn.close();
                    }
                }
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (blockIn != null) {
                    if (throwable != null) {
                        try {
                            blockIn.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        blockIn.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    public static long findVirtualOffsetOfFirstRecordInBam(SeekableStream seekableStream) {
        try {
            return BAMFileReader2.findVirtualOffsetOfFirstRecord(seekableStream);
        }
        catch (IOException ioe) {
            throw new RuntimeEOFException((Throwable)ioe);
        }
    }
}

