/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SBIIndex;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SBIIndexWriter {
    public static final long DEFAULT_GRANULARITY = 4096L;
    private static final byte[] EMPTY_MD5 = new byte[16];
    private static final byte[] EMPTY_UUID = new byte[16];
    private final OutputStream out;
    private final long granularity;
    private final File tempOffsetsFile;
    private final BinaryCodec tempOffsetsCodec;
    private long prev = -1L;
    private long recordCount;
    private long virtualOffsetCount;

    public SBIIndexWriter(OutputStream out) {
        this(out, 4096L);
    }

    public SBIIndexWriter(OutputStream out, long granularity) {
        this.out = out;
        this.granularity = granularity;
        try {
            this.tempOffsetsFile = File.createTempFile("offsets-", ".headerless.sbi");
            this.tempOffsetsCodec = new BinaryCodec((OutputStream)new BufferedOutputStream(new FileOutputStream(this.tempOffsetsFile)));
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public void processRecord(long virtualOffset) {
        if (this.recordCount++ % this.granularity == 0L) {
            this.writeVirtualOffset(virtualOffset);
        }
    }

    private void writeVirtualOffset(long virtualOffset) {
        if (this.prev > virtualOffset) {
            throw new IllegalArgumentException(String.format("Offsets not in order: %#x > %#x", this.prev, virtualOffset));
        }
        this.tempOffsetsCodec.writeLong(virtualOffset);
        ++this.virtualOffsetCount;
        this.prev = virtualOffset;
    }

    public void finish(long finalVirtualOffset, long dataFileLength) {
        this.finish(finalVirtualOffset, dataFileLength, null, null);
    }

    public void finish(long finalVirtualOffset, long dataFileLength, byte[] md5, byte[] uuid) {
        this.writeVirtualOffset(finalVirtualOffset);
        this.tempOffsetsCodec.close();
        if (md5 != null && md5.length != 16) {
            throw new IllegalArgumentException("Invalid MD5 length: " + md5.length);
        }
        if (uuid != null && uuid.length != 16) {
            throw new IllegalArgumentException("Invalid UUID length: " + uuid.length);
        }
        try (BinaryCodec binaryCodec = new BinaryCodec(this.out);
             BufferedInputStream tempOffsets = new BufferedInputStream(new FileInputStream(this.tempOffsetsFile));){
            binaryCodec.writeBytes(SBIIndex.SBI_MAGIC);
            binaryCodec.writeLong(dataFileLength);
            binaryCodec.writeBytes(md5 == null ? EMPTY_MD5 : md5);
            binaryCodec.writeBytes(uuid == null ? EMPTY_UUID : uuid);
            binaryCodec.writeLong(this.recordCount);
            binaryCodec.writeLong(this.granularity);
            binaryCodec.writeLong(this.virtualOffsetCount);
            IOUtil.copyStream((InputStream)tempOffsets, (OutputStream)this.out);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        finally {
            this.tempOffsetsFile.delete();
        }
    }
}

