/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.Locatable;
import java.io.IOException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.disq_bio.disq.FileCardinalityWriteOption;
import org.disq_bio.disq.HtsjdkReadsRdd;
import org.disq_bio.disq.HtsjdkReadsTraversalParameters;
import org.disq_bio.disq.ReadsFormatWriteOption;
import org.disq_bio.disq.TempPartsDirectoryWriteOption;
import org.disq_bio.disq.WriteOption;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.NioFileSystemWrapper;
import org.disq_bio.disq.impl.formats.sam.AbstractSamSource;
import org.disq_bio.disq.impl.formats.sam.SamFormat;

public class HtsjdkReadsRddStorage {
    private JavaSparkContext sparkContext;
    private int splitSize;
    private ValidationStringency validationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private boolean useNio;
    private String referenceSourcePath;

    public static HtsjdkReadsRddStorage makeDefault(JavaSparkContext sparkContext) {
        return new HtsjdkReadsRddStorage(sparkContext);
    }

    private HtsjdkReadsRddStorage(JavaSparkContext sparkContext) {
        this.sparkContext = sparkContext;
    }

    public HtsjdkReadsRddStorage splitSize(int splitSize) {
        this.splitSize = splitSize;
        return this;
    }

    public HtsjdkReadsRddStorage validationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
        return this;
    }

    public HtsjdkReadsRddStorage useNio(boolean useNio) {
        this.useNio = useNio;
        return this;
    }

    public HtsjdkReadsRddStorage referenceSourcePath(String referenceSourcePath) {
        this.referenceSourcePath = referenceSourcePath;
        return this;
    }

    public HtsjdkReadsRdd read(String path) throws IOException {
        return this.read(path, null);
    }

    public <T extends Locatable> HtsjdkReadsRdd read(String path, HtsjdkReadsTraversalParameters<T> traversalParameters) throws IOException {
        FileSystemWrapper fileSystemWrapper = this.useNio ? new NioFileSystemWrapper() : new HadoopFileSystemWrapper();
        String firstSamPath = fileSystemWrapper.isDirectory(this.sparkContext.hadoopConfiguration(), path) ? fileSystemWrapper.firstFileInDirectory(this.sparkContext.hadoopConfiguration(), path) : path;
        SamFormat samFormat = SamFormat.fromPath(firstSamPath);
        if (samFormat == null) {
            throw new IllegalArgumentException("Cannot find format extension for " + path);
        }
        AbstractSamSource abstractSamSource = samFormat.createAbstractSamSource(fileSystemWrapper);
        SAMFileHeader header = abstractSamSource.getFileHeader(this.sparkContext, path, this.validationStringency, this.referenceSourcePath);
        JavaRDD<SAMRecord> reads = abstractSamSource.getReads(this.sparkContext, path, this.splitSize, traversalParameters, this.validationStringency, this.referenceSourcePath);
        return new HtsjdkReadsRdd(header, reads);
    }

    public void write(HtsjdkReadsRdd htsjdkReadsRdd, String path, WriteOption ... writeOptions) throws IOException {
        ReadsFormatWriteOption formatWriteOption = null;
        FileCardinalityWriteOption fileCardinalityWriteOption = null;
        TempPartsDirectoryWriteOption tempPartsDirectoryWriteOption = null;
        for (WriteOption writeOption : writeOptions) {
            if (writeOption instanceof ReadsFormatWriteOption) {
                formatWriteOption = (ReadsFormatWriteOption)writeOption;
                continue;
            }
            if (writeOption instanceof FileCardinalityWriteOption) {
                fileCardinalityWriteOption = (FileCardinalityWriteOption)writeOption;
                continue;
            }
            if (!(writeOption instanceof TempPartsDirectoryWriteOption)) continue;
            tempPartsDirectoryWriteOption = (TempPartsDirectoryWriteOption)writeOption;
        }
        if (formatWriteOption == null) {
            formatWriteOption = SamFormat.formatWriteOptionFromPath(path);
        }
        if (formatWriteOption == null) {
            throw new IllegalArgumentException("Path does not end in BAM, CRAM, or SAM extension, and format not specified.");
        }
        if (fileCardinalityWriteOption == null) {
            fileCardinalityWriteOption = SamFormat.fileCardinalityWriteOptionFromPath(path);
        }
        String tempPartsDirectory = null;
        if (tempPartsDirectoryWriteOption != null) {
            tempPartsDirectory = tempPartsDirectoryWriteOption.getTempPartsDirectory();
        } else if (fileCardinalityWriteOption == FileCardinalityWriteOption.SINGLE) {
            tempPartsDirectory = path + ".parts";
        }
        fileCardinalityWriteOption.getAbstractSamSink(formatWriteOption).save(this.sparkContext, htsjdkReadsRdd.getHeader(), htsjdkReadsRdd.getReads(), path, this.referenceSourcePath, tempPartsDirectory);
    }
}

