/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bam;

import htsjdk.samtools.BAMFileWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.Merger;
import org.disq_bio.disq.impl.formats.bam.HeaderlessBamOutputFormat;
import org.disq_bio.disq.impl.formats.sam.AbstractSamSink;
import scala.Tuple2;

public class BamSink
extends AbstractSamSink {
    private FileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();

    @Override
    public void save(JavaSparkContext jsc, SAMFileHeader header, JavaRDD<SAMRecord> reads, String path, String referenceSourcePath, String tempPartsDirectory) throws IOException {
        Broadcast headerBroadcast = jsc.broadcast((Object)header);
        reads.mapPartitions((FlatMapFunction & Serializable)readIterator -> {
            HeaderlessBamOutputFormat.setHeader((SAMFileHeader)headerBroadcast.getValue());
            return readIterator;
        }).mapToPair((PairFunction & Serializable)samRecord -> new Tuple2(null, samRecord)).saveAsNewAPIHadoopFile(tempPartsDirectory, Void.class, SAMRecord.class, HeaderlessBamOutputFormat.class, jsc.hadoopConfiguration());
        String headerFile = tempPartsDirectory + "/header";
        try (OutputStream out = this.fileSystemWrapper.create(jsc.hadoopConfiguration(), headerFile);){
            BAMFileWriter.writeHeader((OutputStream)out, (SAMFileHeader)header);
        }
        String terminatorFile = tempPartsDirectory + "/terminator";
        try (OutputStream out = this.fileSystemWrapper.create(jsc.hadoopConfiguration(), terminatorFile);){
            out.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
        }
        new Merger().mergeParts(jsc.hadoopConfiguration(), tempPartsDirectory, path);
        this.fileSystemWrapper.delete(jsc.hadoopConfiguration(), tempPartsDirectory);
    }
}

